<!-- Project version history:

                Declared plugin version         Declared project version
     ==========================================================================================
     11a        none (default is 1.0)           none (default is 1.0)
     11b        none (default is 1.0)           none (default is 1.0)
     12a        R2012a                          1.0 (+ extra data ignored by 11a/b)
     12b        R2012a                          1.0 (+ extra data ignored by 11a/b)
     13a prerel R2012a                          R2012a
     13a        R2013a                          R2013a

     Version support was added in 12a. The structure was also significantly changed in addition
     to the content.

     This transformation runs for all projects whose version is undeclared or < R2013a. It forces
     PassStructByReference to be false (the former default/only behavior). This prevents
     possible integration issues that would result from automatically applying the new default
     value of true.
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <!-- Inject the false value -->
    <xsl:template match="profile[@key='profile.c']">
        <profile>
            <xsl:apply-templates select="@*|node()" />
            <param.PassStructByReference>false</param.PassStructByReference>
        </profile>
    </xsl:template>

    <!-- Filter out any existing value plus the unset flag -->
    <xsl:template match="param.PassStructByReference" />

    <xsl:template match="@*|node()">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()"/>
        </xsl:copy>
    </xsl:template>
</xsl:stylesheet>