<!-- Copyright 2014 The MathWorks, Inc. -->

<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:my="http://www.mathworks.com">
    <!-- Duplication of UnifiedTargetFactory profile logic in order to determine the correct param to read -->
    <xsl:variable name="ACTIVE_PROFILE">
        <xsl:variable name="isMex" select="/deployment-project/configuration/param.artifact = 'option.target.artifact.mex'" />
        <xsl:variable name="objective" select="/deployment-project/configuration/param.objective" />
        <xsl:choose>
            <xsl:when test="$objective = 'option.objective.hdl'">profile.hdl</xsl:when>
            <xsl:when test="$objective = 'option.objective.c' and $isMex = false()">profile.c</xsl:when>
            <xsl:otherwise>profile.mex</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
    <xsl:template match="deployment-project">
        <deployment-project plugin="plugin.matlabhdlcoder" plugin-version="R2013a">
            <configuration target="target.matlab.hdlcoder" target-name="HDL Code Generation">
                <xsl:attribute name="file"><xsl:value-of select="configuration/@file" /></xsl:attribute>
                <xsl:attribute name="location"><xsl:value-of select="configuration/@location" /></xsl:attribute>
                <xsl:attribute name="name"><xsl:value-of select="configuration/@name" /></xsl:attribute>

                <xsl:apply-templates select="configuration/node()[starts-with(name(), 'param.')]" />
                <xsl:apply-templates select="configuration/node()[name() = 'unset']" />
                <xsl:apply-templates select="configuration/node()[name() != 'unset' and not(starts-with(name(), 'param.'))]" />
            </configuration>
        </deployment-project>
    </xsl:template>

    <xsl:template match="param.objective"/>
    <xsl:template match="param.UseGlobals"/>
    <xsl:template match="param.TestSnippets"/>
    <xsl:template match="var.LegacyTarget"/>
    <xsl:template match="var.MirrorOnOpen"/>

    <!-- HDL testbench fileset -->
    <xsl:template match="fileset.testbench">
        <fileset.scriptfile>
            <xsl:apply-templates/>
        </fileset.scriptfile>
    </xsl:template>

    <!-- Unwrap the HDL profile settings -->
    <xsl:template match="profile[@key = 'profile.hdl']">
        <xsl:apply-templates />
    </xsl:template>

    <xsl:template match="profile[@key != 'profile.hdl' and @key != $ACTIVE_PROFILE]"/>

    <xsl:template match="profile[@key != 'profile.hdl' and @key = $ACTIVE_PROFILE]">
        <xsl:call-template name="writeIfActive">
            <xsl:with-param name="inputName" select="'param.GenerateComments'" />
        </xsl:call-template>

        <xsl:call-template name="writeIfActive">
            <xsl:with-param name="inputName" select="'param.MATLABSourceComments'" />
        </xsl:call-template>

        <xsl:call-template name="writeIfActive">
            <xsl:with-param name="inputName" select="'param.GenerateReport'" />
        </xsl:call-template>

        <xsl:call-template name="writeIfActive">
            <xsl:with-param name="inputName" select="'param.SearchPaths'" />
            <xsl:with-param name="outputName" select="'param.hdl.SearchPath'" />
        </xsl:call-template>

        <xsl:call-template name="writeIfActive">
            <xsl:with-param name="inputName" select="'param.SpecifiedWorkingFolder'" />
            <xsl:with-param name="outputName" select="'param.hdl.WorkingSpecifiedDirectory'" />
        </xsl:call-template>

        <xsl:call-template name="writeIfActive">
            <xsl:with-param name="inputName" select="'param.SpecifiedBuildFolder'" />
            <xsl:with-param name="outputName" select="'param.hdl.BuildSpecifiedDirectory'" />
        </xsl:call-template>

        <xsl:variable name="workingFolderTranslation">
            <xsl:choose>
                <xsl:when test="param.BuildFolder/text() = 'option.WorkingFolder.Project'">option.hdl.ProjectDirectory</xsl:when>
                <xsl:when test="param.BuildFolder/text() = 'option.WorkingFolder.Current'">option.hdl.CurrentDirectory</xsl:when>
                <xsl:when test="param.BuildFolder/text() = 'option.WorkingFolder.Specified'">option.hdl.WorkingSpecifiedDirectory</xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="''" />
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:call-template name="writeIfActive">
            <xsl:with-param name="inputName" select="'param.WorkingFolder'" />
            <xsl:with-param name="outputName" select="'param.hdl.WorkingDirectory'" />
            <xsl:with-param name="overrideValue" select="$workingFolderTranslation" />
        </xsl:call-template>

        <xsl:variable name="buildFolderTranslation">
            <xsl:choose>
                <xsl:when test="param.BuildFolder/text() = 'option.BuildFolder.Project'">option.hdl.ProjectDirectory</xsl:when>
                <xsl:when test="param.BuildFolder/text() = 'option.BuildFolder.Current'">option.hdl.CurrentDirectory</xsl:when>
                <xsl:when test="param.BuildFolder/text() = 'option.BuildFolder.Specified'">option.hdl.BuildSpecifiedDirectory</xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="''" />
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:call-template name="writeIfActive">
            <xsl:with-param name="inputName" select="'param.BuildFolder'" />
            <xsl:with-param name="outputName" select="'param.hdl.BuildDirectory'" />
            <xsl:with-param name="overrideValue" select="$buildFolderTranslation" />
        </xsl:call-template>
    </xsl:template>

    <!-- Rename HDL params that are not HDL-specific and have simpler-named counterparts in C Coder -->

    <xsl:template match="param.InstrumentedMexFile">
        <xsl:call-template name="wrapFixptConv" />
    </xsl:template>

    <xsl:template match="param.InstrumentedBuildChecksum">
        <xsl:call-template name="wrapFixptConv" />
    </xsl:template>

    <xsl:template match="param.ShowCoverage">
        <xsl:call-template name="wrapFixptConv" />
    </xsl:template>

    <xsl:template match="param.FixedPointValidationChecksum">
        <xsl:call-template name="wrapFixptConv" />
    </xsl:template>

    <xsl:template match="param.FixedPointSourceCodeChecksum">
        <xsl:call-template name="wrapFixptConv" />
    </xsl:template>

    <xsl:template match="param.FixedPointStaticAnalysisChecksum">
        <xsl:call-template name="wrapFixptConv" />
    </xsl:template>

    <xsl:template match="param.DefaultTestFile">
        <xsl:call-template name="wrapFixptConv" />
    </xsl:template>

    <xsl:template match="param.ExcludedFixedPointVerificationTestFiles">
        <xsl:call-template name="wrapFixptConv" />
    </xsl:template>

    <xsl:template match="param.ContainerTypes">
        <xsl:call-template name="wrapFixptConv" />
    </xsl:template>

    <xsl:template match="param.FixedPointTypeProposalMode">
        <param.fixptconv.FixptProposalKind>
            <xsl:choose>
                <xsl:when test="text() = 'option.FixedPointTypeProposalMode.ProposeFractionLengths'">
                    option.fixptconv.ProposeFracLenBasedOnWordLen
                </xsl:when>
                <xsl:when test="text() = 'option.FixedPointTypeProposalMode.ProposeWordLengths'">
                    option.fixptconv.ProposeWordLenBasedOnFracLen
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates />
                </xsl:otherwise>
            </xsl:choose>
        </param.fixptconv.FixptProposalKind>
    </xsl:template>

    <xsl:template match="param.hdl.LegacyDefaultTestFile">
        <param.DefaultTestFile>
            <xsl:apply-templates />
        </param.DefaultTestFile>
    </xsl:template>

    <xsl:template match="param.DefaultWordLength">
        <param.fixptconv.DefaultFixptWordLength>
            <xsl:apply-templates />
        </param.fixptconv.DefaultFixptWordLength>
    </xsl:template>

    <xsl:template match="param.DefaultFractionLength">
        <param.fixptconv.DefaultFixptFractionLength>
            <xsl:apply-templates />
        </param.fixptconv.DefaultFixptFractionLength>
    </xsl:template>

    <xsl:template match="param.FixedPointSafetyMargin">
        <param.fixptconv.SafetyMargin>
            <xsl:apply-templates />
        </param.fixptconv.SafetyMargin>
    </xsl:template>

    <xsl:template match="param.FixedPointTypeSource">
        <param.fixptconv.ProposeUsingDesignMinMaxAnd>
            <xsl:apply-templates />
        </param.fixptconv.ProposeUsingDesignMinMaxAnd>
    </xsl:template>

    <xsl:template match="param.FixedPointFimath">
        <param.fixptconv.FiMathString>
            <xsl:apply-templates />
        </param.fixptconv.FiMathString>
    </xsl:template>

    <xsl:template match="param.PlotFunction">
        <xsl:call-template name="wrapFixptConv" />
    </xsl:template>

    <xsl:template match="param.UserFixedPointData">
        <param.transformedVariables>
            <xsl:apply-templates />
        </param.transformedVariables>
    </xsl:template>

    <xsl:template match="param.ComputedFixedPointData">
        <param.computedVariables>
            <xsl:apply-templates />
        </param.computedVariables>
    </xsl:template>

    <xsl:template match="param.LogAllIOValues">
        <xsl:call-template name="wrapFixptConv" />
    </xsl:template>

    <xsl:template match="param.DetectOverflows">
        <xsl:call-template name="wrapFixptConv" />
    </xsl:template>

    <xsl:template match="param.LogHistogram">
        <xsl:call-template name="wrapFixptConv" />
    </xsl:template>

    <xsl:template match="param.GeneratedFixedPointFileSuffix">
        <param.fixptconv.FixPtFileNameSuffix>
            <xsl:apply-templates />
        </param.fixptconv.FixPtFileNameSuffix>
    </xsl:template>

    <xsl:template match="param.AutoScaleLoopIndexVariables">
        <xsl:call-template name="wrapFixptConv" />
    </xsl:template>

    <xsl:template match="param.FixedPointFunctionReplacements">
        <param.fixptconv.generatefixptcode.function_replacements>
            <xsl:apply-templates />
        </param.fixptconv.generatefixptcode.function_replacements>
    </xsl:template>

    <xsl:template match="param.OptimizeWholeNumbers">
        <xsl:call-template name="wrapFixptConv" />
    </xsl:template>

    <xsl:template match="param.DefaultFixedPointSignedness">
        <param.fixptconv.DefaultFixedPointSignedness>
            <xsl:value-of select="replace(text(), 'option.', 'option.fixptconv.')"/>
        </param.fixptconv.DefaultFixedPointSignedness>
    </xsl:template>

    <xsl:template match="param.StaticAnalysisTimeout">
        <xsl:call-template name="wrapFixptConv" />
    </xsl:template>

    <xsl:template match="param.StaticAnalysisGlobalRangesOnly">
        <xsl:call-template name="wrapFixptConv" />
    </xsl:template>

    <!-- Utility templates -->

    <xsl:template name="wrapFixptConv">
        <xsl:element name="{concat('param.fixptconv.', substring-after(name(), 'param.'))}">
            <xsl:apply-templates />
        </xsl:element>
    </xsl:template>

    <xsl:template name="wrapHdl">
        <xsl:element name="{concat('param.hdl.', substring-after(name(), 'param.'))}">
            <xsl:apply-templates />
        </xsl:element>
    </xsl:template>

    <xsl:template name="writeIfActive">
        <xsl:param name="inputName"/>
        <xsl:param name="outputName" select="concat('param.hdl.', substring-after($inputName, 'param.'))"/>
        <xsl:param name="overrideValue" select="''" />
        <xsl:if test="name(.) = 'profile' and @key = $ACTIVE_PROFILE and child::node()[name() = $inputName and string(.)]">
            <xsl:element name="{$outputName}">
                <xsl:choose>
                    <xsl:when test="string-length($overrideValue) > 0">
                        <xsl:value-of select="$overrideValue"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:apply-templates select="child::node()[name() = $inputName]/text()"/>
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:apply-templates select="child::node()[name() = $inputName]/*"/>
            </xsl:element>
        </xsl:if>
    </xsl:template>

    <xsl:template match="@*|node()">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()"/>
        </xsl:copy>
    </xsl:template>
</xsl:stylesheet>