<!-- Copyright 2014 The MathWorks, Inc. -->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:template match="deployment-project">
        <deployment-project plugin="plugin.matlabcoder" plugin-version="R2014a_nu">
            <configuration target="target.matlab.coder" target-name="MEX, C, and C++ Code Generation">
                <xsl:attribute name="file"><xsl:value-of select="configuration/@file" /></xsl:attribute>
                <xsl:attribute name="location"><xsl:value-of select="configuration/@location" /></xsl:attribute>
                <xsl:attribute name="name"><xsl:value-of select="configuration/@name" /></xsl:attribute>

                <xsl:apply-templates select="configuration/node()[starts-with(name(), 'param.')]" />
                <xsl:apply-templates select="configuration/node()[name() = 'unset']" />
                <xsl:apply-templates select="configuration/node()[name() != 'unset' and not(starts-with(name(), 'param.'))]" />
            </configuration>
        </deployment-project>
    </xsl:template>

    <xsl:template match="param.objective"/>
    <xsl:template match="param.UseGlobals"/>
    <xsl:template match="param.TestSnippets"/>
    <xsl:template match="var.LegacyTarget"/>

    <xsl:template match="@*|node()">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()"/>
        </xsl:copy>
    </xsl:template>
</xsl:stylesheet>