// Copyright 2014 MathWorks, Inc.
define([
    "dojo/_base/declare",
    "addons/util/PostMessageChannel",
    "addons/util/MessageServiceHelper",
    "addons/AddonsBrowser/GalleryToBrowserMessages",
    "dojo/domReady!"
], function (declare, PostMessageChannel, MSHelper, GalleryToBrowserMessages) {

    var CONST_GET_INSTALLED_ADD_ONS_FOR_ADDONS_GALLERY = "getInstalledAddOnsForAddOnsGallery";
    var channel;
    var msHelper;
    return declare ([], {
        constructor: function (args) {
            var data = args || {};
            var msHelperArgs = {
                channelId: data.channelId,
                callback: this._matlabMessageHandler.bind(this)
            }
            msHelper = new MSHelper(msHelperArgs);

        },
        registerEventListeners: function () {
            channel = new PostMessageChannel(window);
            channel.connect(window.parent);
            channel.on(GalleryToBrowserMessages.GET_INSTALLED_ADD_ONS, this._handleGetInstalledAddons);
            channel.on(GalleryToBrowserMessages.INSTALL_ADD_ON, this._handleInstallAddon);
            channel.on(GalleryToBrowserMessages.LOG_IN, this._handleLogInMessage);
            channel.on(GalleryToBrowserMessages.LOG_OUT, this._handleLogOutMessage);
            channel.on(GalleryToBrowserMessages.OPEN_SYSTEM_BROWSER, this._handleOpenSystemBrowserMessage);
            channel.on(GalleryToBrowserMessages.OPEN_ADDON_MANAGER, this._handleOpenAddonManager);
        },

        _handleGetInstalledAddons: function () {
            var getInstalledAddonsMessage = {
                type: CONST_GET_INSTALLED_ADD_ONS_FOR_ADDONS_GALLERY
            };
            msHelper.publish(getInstalledAddonsMessage);
        },

        _handleInstallAddon: function (message) {
            var installAddonMessage = message.body;
            installAddonMessage.type = message.type;
            msHelper.publish(installAddonMessage);
        },

        _handleOpenAddonManager: function (message) {
            var openAddonManagerMessage = message.body;
            openAddonManagerMessage.type = message.type;
            msHelper.publish(openAddonManagerMessage);
        },

        sendMessage: function (message) {
            channel.send(message.type, message.body);
        },

        _handleLogInMessage: function (message) {
            var logInMessage = {
                type: message.type
            };
            msHelper.publish(logInMessage);
        },

        _handleLogOutMessage: function (message) {
            var logOutMessage = {
                type: message.type
            };
            msHelper.publish(logOutMessage);
        },

        _handleOpenSystemBrowserMessage: function (message) {
            var openSystemBrowserMessage = message.body;
            openSystemBrowserMessage.type = message.type;
            msHelper.publish(openSystemBrowserMessage);
        },
        _matlabMessageHandler: function (message) {
            var data = message.data;
            this.sendMessage(data);
        }
    });
});
