// Copyright 2014 MathWorks, Inc.
require([
    "dojo/dom",
    "dojo/i18n!l10n-addons/nls/addonsManager",
    "dojo/io-query",
    "dojo/query",
    "MW/remote/MessageService",
    "addons/AddonsManager/GetInstalledAddonsEvent",
    "addons/AddonsManager/ManagerToMatlabMessages",
    "dojo/domReady!"
], function (dom, addonsManagerResourceBundle, ioQuery, query, MessageService,
             GetInstalledAddonsEvent, ManagerToMatlabMessages) {

    "use strict";

    dom.byId("getMore").innerHTML = addonsManagerResourceBundle.getMore;
    dom.byId("packageToolbox").innerHTML = addonsManagerResourceBundle.packageToolbox;
    dom.byId("packageApp").innerHTML = addonsManagerResourceBundle.packageApp;
    dom.byId("sortByLabel").innerHTML = addonsManagerResourceBundle.sortByLabel;
    dom.byId("sortByInstalledDate").innerHTML = addonsManagerResourceBundle.sortByInstalledDate;
    dom.byId("sortByType").innerHTML = addonsManagerResourceBundle.sortByType;
    dom.byId("sortByName").innerHTML = addonsManagerResourceBundle.sortByName;
    dom.byId("sortByIsSupportedByMathWorks").innerHTML = addonsManagerResourceBundle.sortByIsSupportedByMathWorks;
    dom.byId("sortByAuthor").innerHTML = addonsManagerResourceBundle.sortByAuthor;

    var searchSubstring = window.location.search.substring(1);
    var mlQueryParams = ioQuery.queryToObject(searchSubstring);

    var ManagerEventsInstance = new GetInstalledAddonsEvent(mlQueryParams);
    ManagerEventsInstance.publishMessage({
        type: ManagerToMatlabMessages.GET_INSTALLED_ADD_ONS_FOR_MANAGER
    });

});
