// Copyright 2014 MathWorks, Inc.

define(["addons/AddonsManager/InstalledAddonWidget",
    "addons/AddonsManager/ManagerSort",
    "dojo/dom",
    "dojo/_base/array",
    "dojo/domReady!",
    "require"],
    function (InstalledAddonWidget, ManagerSort, dom, arrayUtil) {

        var installedAddonsContainer = dom.byId("installedAddonsContainer");

        function renderSortedInstalledAddons(sortedInstalledAddons) {
            arrayUtil.forEach(sortedInstalledAddons, function (installedAddon) {
                // Create our widget and place it
                var widget = new InstalledAddonWidget(installedAddon).placeAt(installedAddonsContainer);
            });
        }

        return {
            sortAndDisplay: function (installedAddons, sortType) {
                installedAddonsContainer.innerHTML = "";
                installedAddons.sort(ManagerSort.sortByInstalledDate);
                installedAddons.sort(sortType);
                renderSortedInstalledAddons(installedAddons);
            }
        }

    });