// Copyright 2014 MathWorks, Inc.

define([
    "addons/AddonsManager/ManagerRenderAddons",
    "addons/AddonsManager/ManagerSort",
    "dojo/dom",
    "dojo/domReady!",
    "require"
], function (ManagerRenderAddons, ManagerSort, dom) {

    "use strict";

    return{
        enableSorting: function(installedAddonsData){
            var sortMenu = dom.byId("sortBySelector");
            var installedAddonsList = installedAddonsData;

            sortMenu.onchange = function () {
                var selectionValue = this.selectedOptions[0].value;
                switch (selectionValue) {
                    case "author":
                        ManagerRenderAddons.sortAndDisplay(installedAddonsList, ManagerSort.sortByAddonAuthor);
                        break;
                    case "name":
                        ManagerRenderAddons.sortAndDisplay(installedAddonsList, ManagerSort.sortByAddonName);
                        break;
                    case "type":
                        ManagerRenderAddons.sortAndDisplay(installedAddonsList, ManagerSort.sortByAddonType);
                        break;
                    case "installedDate":
                        ManagerRenderAddons.sortAndDisplay(installedAddonsList, ManagerSort.sortByInstalledDate);
                        break;
                    case "isSupportedByMathWorks":
                        ManagerRenderAddons.sortAndDisplay(installedAddonsList,
                            ManagerSort.sortByIsSupportedByMathworks);
                        break;
                    default:
                        ManagerRenderAddons.sortAndDisplay(installedAddonsList, ManagerSort.sortByInstalledDate);
                        break;
                }
            };
        }
    };
});