// Copyright 2014 MathWorks, Inc.
define([
    "dojo/_base/declare",
    "MW/remote/MessageService"
], function (declare, MessageService) {

    var PUBLISH_CHANNEL_PREFIX = "/matlab/addons/sub";
    var SUBSCRIBE_CHANNEL_PREFIX = "/matlab/addons/pub";

    return declare([],{
        constructor: function (args) {
            var data = args || {};
            this._publishChannel = PUBLISH_CHANNEL_PREFIX + data.channelId;
            this._subscribeChannel = SUBSCRIBE_CHANNEL_PREFIX + data.channelId;
            MessageService.start();
            this.subscribe(args.callback);
        },
        _publishChannel: "",
        _subscribeChannel: "",
        publish: function (message) {
            MessageService.publish(this._publishChannel, message);
        },
        subscribe: function (callback) {
            MessageService.subscribe (this._subscribeChannel, callback);
        }
	});
});
