/**
 * Created with IntelliJ IDEA.
 * User: kkaminen
 * Date: 3/7/14
 * Time: 1:54 PM
 * To change this template use File | Settings | File Templates.
 */

define(["dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/dom-construct",
    "dojo/dom-geometry",
    "dijit/_WidgetBase",
    "visualcomponents/graphics/MWSG/json_scenetree",
    //"visualcomponents/graphics/MWSG/Interaction3d",
    "MW/remote/MessageService",
    "dijit/_TemplatedMixin",
    "dojo/text!./templates/Canvas.html"
], function (declare, lang, dom, domGeom, _WidgetBase, GfxTree, MessageService, _TemplatedMixin, template) {

    return declare([_WidgetBase, _TemplatedMixin], {
        /**
         * Overrides the base class CSS
         * This String is used by the template, and gets inserted into
         * template to create the CSS for this widget
         */
        baseClass: "Canvas",
        /**
         * Default Height of the canvas
         */
        canvasHeight: 400,
        /**
         * Default Width of the canvas
         */
        canvasWidth: 600,
        /**
         * A string that represents the widget template
         */
        templateString: template,

        constructor: function (args) {

            //Input Validation
            if (args && !args.Container) {
                throw new Error('Container argument must be passed to the CanvasDijit constructor');
            }

            if (!args.PeerChannelId) {
                throw new Error('PeerChannelId argument must be passed to the CanvasDijit constructor');
            }

            this.Container = args.Container;
            this.ParentNode = args.ParentNode || this.Container.containerNode;

            this.ID = args.PeerChannelId;

            // SceneTree
            this.SceneTree = new GfxTree(this);

            // Interactions
            // Removed to disable interactions
            //this._PZR = new Interaction3d(this.SceneTree, this.getCanvas(), 3);

            MessageService.subscribe("/canvas/" + this.ID + "/command", lang.hitch(this, this.dispatchGraphicsCommand));
        },

        /**
         * @override
         */
        postCreate: function () {
            this.SceneTree.setCanvas(this.getCanvas());

            // set the renderer to painters for now
            this.dispatchGraphicsCommand({ data: {cmd: "setRenderMode", mode: "painters"}});

            this.inherited(arguments);
        },

        getContainerDimensions: function (node) {
            if (!node) {
                throw new Error('Argument node must be defined');
            }

            var position = domGeom.position(node);

            if (position.h === 0 && position.w === 0) {
                return this.getContainerDimensions(node.parentNode);
            }
            return position;
        },

        addToContainer: function (container, position) {
            //If the container is a DOM element add the canvas at the position
            //If the container is a Dijit, add the canvas as a direct child of the
            //Dijit domNode.
            var node;

            if (container && container.containerNode) {
                node = container.containerNode;
            } else {
                node = container;
            }

            if (node) {
                dom.place(this.domNode, node, position || "last");
            } else {
                throw new Error('Argument container must be defined');
            }
        },

        setDimensions: function (width, height) {
            this.domNode.height = !isNaN(parseFloat(height)) && isFinite(height) ? height : 0;
            this.domNode.width = !isNaN(parseFloat(width)) && isFinite(width) ? width : 0;
        },

        setDefaultDimensions: function () {
            var position = this.getContainerDimensions(this.ParentNode);

            this.setDimensions(position.w, position.h);
        },

        getCanvas: function () {
            return this.domNode;
        },

        replaceCanvas: function () {
            //No-op until we need an implementation
        },

		/*
		* redrawCanvas handles the 'PositionChanged' events from MatLab, which for Figures, 
		* are triggered by the CEF window. If an event is triggered but width and height are 
		* unchanged, we can simply use the SceneTree to redraw the canvas image. 
		* However, to prevent the stretch and jump flickering effect, we need to temporarily cache the image
		* to an off screen canvas and repaint after resize. This flicker only happens when a fixed size unit
		* (i.e. pixels, inches) is set on the axes. 
		*/
        redrawCanvas: function () {
            var position = this.getContainerDimensions(this.ParentNode);

			var unchangedHeight = (this.domNode.height === position.h);
			var unchangedWidth = (this.domNode.width === position.w);
			
			var sameSize = unchangedHeight && unchangedWidth;
			
			if (sameSize) {
					this.SceneTree.draw();
			} else {
				
				//g1055752
				var tempCanvas = document.createElement('canvas');
				tempCanvas.width = this.domNode.width;
				tempCanvas.height = this.domNode.height;
				var tempContext = tempCanvas.getContext("2d");				
				
				var context = this.SceneTree._renderer._context;
				
				tempContext.drawImage(context.canvas, 0, 0);
				
				this.setDimensions(position.w, position.h);
				
				context.drawImage(tempContext.canvas, 0, 0);
			} 
			
			 /*this.setDimensions(position.w, position.h);
           this.SceneTree.draw();*/
        },

        dispatchGraphicsCommand: function (cmd) {
            if (!(cmd && cmd.data)) {
                throw new Error('Argument cmd must have a valid data object');
            }

            this.SceneTree.process_cmd(cmd.data);
        }
    });
});

