/**
 * Created with IntelliJ IDEA.
 * User: kkaminen
 * Date: 3/4/14
 * Time: 1:43 PM
 * To change this template use File | Settings | File Templates.
 */

define([
    "dojo/_base/declare",
    "dojo/dom-class",
    "dojo/dom-geometry",
    "dojo/dom-style",
    "dojo/_base/lang",
    "gbt/widgetview/customdijit/GraphicsContainer",

    "dijit/_WidgetBase",
    "dijit/_TemplatedMixin",
    "dijit/_Container",

    "dojo/text!./templates/Panel.html",
    "./_FontStyleMixin",
    "./_PositionableMixin",
    "./_PixelConstants",
    "./utils",
    'xstyle/css!/toolbox/matlab/uitools/uicomponents/web/js/gbt/widgetview/customdijit/resources/css/Panel.css'
], function (declare, domClass, domGeometry, domStyle, lang, GraphicsContainer, _WidgetBase, _TemplatedMixin,
             _Container, template, _FontStyleMixin, _PositionableMixin, _PixelConstants, utils) {

    // The divider below the title is 1 px tall. this needs to be accounted for, when setting the height of the containerNode
    var UNDERLINE_NODE_THICKNESS = 1;

    return declare([GraphicsContainer, _WidgetBase, _TemplatedMixin, _Container, _FontStyleMixin, _PositionableMixin], {

        baseClass: "mwPanel",

        // title: String
        //          Text that shows up on the top left of the Panel. It comes with a line below it.
        title: "Panel Title",

        templateString: template,

        // isBorderVisible: Boolean
        //                  should the border be shown or not
        isBorderVisible: true,

        // outerWidth: float
        //              pixel width to set the domNode to
        outerWidth: 160,

        // outerHeight: float
        //              pixel height to set the domNode to
        outerHeight: 120,


        constructor: function () {
            // Override default width and height from _PositionableMixin
            // Additionally, since these need to be set on the containerNode, the setters for the same are also overridden
            this.width = 160;
            this.height = 120;
        },

        /**
         * Update default width and height
         * Watch for changes to title (content and its font properties) to trigger a preferred Size calculation
         */
        postCreate: function () {
            this.inherited(arguments);

            // preferred size updates
            this.own(
                this.watch("title", lang.hitch(this, this._updatePreferredSize)),
                this.watch("width", lang.hitch(this, this._updatePreferredSize)),
                this.watch("height", lang.hitch(this, this._updatePreferredSize)),
                this.watch("fontFamily", lang.hitch(this, this._updatePreferredSize)),
                this.watch("fontSize", lang.hitch(this, this._updatePreferredSize)),
                this.watch("fontAngle", lang.hitch(this, this._updatePreferredSize)),
                this.watch("fontWeight", lang.hitch(this, this._updatePreferredSize))
            );
        },

        /**
         * Update the preferredSize after laying it out on the DOM
         */
        startup: function () {
            this._updatePreferredSize();
            this.inherited(arguments);

        },

        /**
         * Override from _FontStyleMixin to return the titleNode
         * @returns {*}
         * @private
         */
        _getNodeToApplyFontProperties: function () {
            return this.titleNode;
        },

        /**
         * Updates the preferredSize property with recommended sizes of width, height, outerWidth and outerHeight
         * for the Panel, but does not apply it. It is upto the widget user to choose to use this.
         * @private
         */
        _updatePreferredSize: function () {
            var titleNodeDimensions = domGeometry.position(this.titleNode),
                width,
                outerWidth;

            if (titleNodeDimensions.w > this.width) {
                width = outerWidth = titleNodeDimensions.w;
            } else {
                width = outerWidth = this.width;
            }

            this.set("preferredSize", {
                height: this.height,
                width: utils.formatNumber(width),
                outerHeight: this.height + utils.formatNumber(titleNodeDimensions.h),
                outerWidth: utils.formatNumber(outerWidth)
            });
        },

        /**
         * Set the user-specified title
         * @param title: String
         * @private
         */
        _setTitleAttr: function (title) {
            this.titleNode.innerHTML = title;
            if (title.toString().length === 0) {
                domClass.add(this.titleNode, "panelTitleBlank");
            } else {
                domClass.remove(this.titleNode, "panelTitleBlank");
            }
            this._set("title", title);
        },

        /**
         * Turns the border On/Off
         * @param isBorderVisible: Boolean
         * @private
         */
        _setIsBorderVisibleAttr: function (isBorderVisible) {
            isBorderVisible ? domClass.add(this.domNode, "panelBorder") : domClass.remove(this.domNode, "panelBorder");
            this._set("isBorderVisible", isBorderVisible);
        },

        /**
         * Enables/Disables the Panel: It has the effect of not being able to interact with the widgets inside the panel
         * @param isDisabled
         * @private
         */
        _setDisabledAttr: function(isDisabled) {
            isDisabled ?  domClass.add(this.domNode, "mwPanelDisabled") : domClass.remove(this.domNode, "mwPanelDisabled");
            this._set("disabled", isDisabled);
        },

        /**
         *  Updates the width (on inner-art) after accounting for the outer-art's 1px border on each side
         * @param width
         * @private
         */
        _setWidthAttr: function (width) {
            var widthAfterVisualEffects;
            if (this.get("isBorderVisible")) {
                widthAfterVisualEffects =   width - _PixelConstants.COMMON.BORDER_LEFTRIGHT;
            } else {
                widthAfterVisualEffects =   width;
            }
            domStyle.set(this.containerNode, {"width": widthAfterVisualEffects +"px"});
            this._set("width", width);
        },

        /**
         * Updates the width (on inner-art) after accounting for the outer-art's 1px border on each side + 1 px thickness of the underline(line below th title)
         * @param height
         * @private
         */
        _setHeightAttr: function (height) {
            var heightAfterVisualEffects;
            if (this.get("isBorderVisible")) {
                heightAfterVisualEffects =   height  - _PixelConstants.COMMON.BORDER_TOP_BOTTOM;
            } else {
                heightAfterVisualEffects =   height;
            }
            if (this.get("title").length > 0) {
                heightAfterVisualEffects = heightAfterVisualEffects - UNDERLINE_NODE_THICKNESS;
            }
            domStyle.set(this.containerNode, {"height": heightAfterVisualEffects +"px"});
            this._set("height", height);
        },

        /**
         * Updates the width of the outer art
         * @param outerWidth: Number
         * @private
         */
        _setOuterWidthAttr: function (outerWidth) {
            domStyle.set(this.domNode, {"width": outerWidth + "px"});
            this._set("outerWidth", outerWidth);
        },

        /**
         * Updates the height of the outer art
         * @param outerHeight: Number
         * @private
         */
        _setOuterHeightAttr: function (outerHeight) {
            domStyle.set(this.domNode, {"height": outerHeight + "px"});
            this._set("outerHeight", outerHeight);
        }


    });
});