/**
 * This can be mixed into all custom Dijits which need to be sized.
 *
 */

define([
    "dojo/_base/declare",
    "dojo/dom-style",
    "./_PixelConstants"
], function (declare, domStyle, PixelConstants) {

        return declare(null, {


            // width: float
            //         pixel width to set the widget's domNode to
            width:  100.00,

            // height:  float
            //        pixel height to set the widget's domNode to
            height: 20.00,

            // preferredSize: Object
            //              An object with fields {width, outerWidth, height and outerHeight} representing the dimensions required to show the
            //              overall component bounds, with no extra spacing and no clipping.
            preferredSize: {},


            // constants for padding
            //
            // Can be accessed by subclasses that need to know how things are padded
            OVERALL_HEIGHT_PADDING : PixelConstants.COMMON.BORDER_TOP_BOTTOM + PixelConstants.COMMON.DROP_SHADOW,
            OVERALL_WIDTH_PADDING : PixelConstants.COMMON.PADDING_LEFT + PixelConstants.COMMON.PADDING_RIGHT + PixelConstants.COMMON.BORDER_LEFTRIGHT,

            constructor: function () {
                // Object types must be explicitly initialized in the constructor, else all instances will share the same object via the prototype chain
                this.preferredSize = {};
            },


            /**
             * Set the width after accounting for the visual effects
             * @param width - Number
             * @private
             */
            _setWidthAttr: function (width) {
                var widthAfterVisualEffects = this._getWidthSansVisualEffects(width);
                domStyle.set(this.domNode, {
                    "width": widthAfterVisualEffects + "px"
                });
                this._set("width", width);
            },

            /**
             *  Set the height after accounting for the visual effects
             * @param height - Number
             * @private
             */
            _setHeightAttr: function (height) {
                var heightAfterVisualEffects = this._getHeightSansVisualEffects(height);
                domStyle.set(this.domNode, {
                    "height": heightAfterVisualEffects + "px"
                });
                this._set("height", height);
            },

            /**
             * Returns the pixel value of the width that the node must be set to after accounting for
             * 1. 2px padding on the left
             * 2. 2px padding on the right
             * 3. 2px border on right and left combined
             * @param width
             * @returns {number}
             * @protected
             */
            _getWidthSansVisualEffects: function (width) {
                return (width - this.OVERALL_WIDTH_PADDING);
            },

            /**
             * Returns the pixel value of the height that the node must be set to after accounting for
             * 1. 2px border on top and bottom combined
             * 2. 1px Drop-shadow
             * @param height
             * @returns {number}
             * @protected
             */
            _getHeightSansVisualEffects: function (height) {
                return (height - this.OVERALL_HEIGHT_PADDING);
            }

        });
    }
);
