/**
 * Created with IntelliJ IDEA.
 * User: kkaminen
 * Date: 10/2/13
 * Time: 11:02 AM
 * To change this template use File | Settings | File Templates.
 */
define([
    "dojo/_base/declare",
    "dojo/on",
    "dojo/dom-class",
    "dojo/dom-style",
    "dijit/form/Button",
    "dojo/text!./templates/Button.html"
], function (declare, on, domClass, domStyle, Button, template) {

    return declare([Button], {

        region: 'null',

        templateString: template,

        //internal width and height attributes
        width: 0,
        height:0,

        postCreate: function () {
            this.inherited(arguments);
        },

        setWidth: function (/*String*/width) {
            domStyle.set(this.domNode, {"width": width + "px"});
            domStyle.set(this.clickNode, {"width": width + "px"});
            this._set("width", width);
        },

        setHeight: function (/*String*/ height) {
            domStyle.set(this.domNode, {"height": height + "px"});
            domStyle.set(this.clickNode, {"height": height + "px"});
            this._set("height", height);
        },

        _setLabelAttr: function(/*String*/content) {
            this.inherited(arguments);
            domClass.add(this.titleNode, 'dojoxEllipsis');
        },

        color: function(newColor) {
            domStyle.set(this.domNode, {color: newColor});
        },

        zIndex: function(index) {
            domStyle.set(this.domNode, {"z-index": index});
        }

    });

});

