/* $Revision: 1.2 $ */
#ifndef	__D3DRMDEFS_H__ 
#define	__D3DRMDEFS_H__ 
#include	<stddef.h> 
#include	"d3dtypes.h" 
#define	D3DRMAPI __stdcall 
#ifndef	TRUE 
#define	FALSE 0 
#define	TRUE 1 
#endif	
typedef	struct _D3DRMVECTOR4D { D3DVALUE x, y, z, w; } D3DRMVECTOR4D, *LPD3DRMVECTOR4D; 
typedef	D3DVALUE D3DRMMATRIX4D[4][4]; 
typedef	struct _D3DRMQUATERNION { D3DVALUE s; D3DVECTOR v; } D3DRMQUATERNION, *LPD3DRMQUATERNION; 
typedef	struct _D3DRMBOX { D3DVECTOR min, max; } D3DRMBOX, *LPD3DRMBOX; 
typedef	void (*D3DRMWRAPCALLBACK) (LPD3DVECTOR, int*,int* ,LPD3DVECTOR,LPD3DVECTOR,LPVOID); 
typedef	enum _D3DRMLIGHTTYPE 
{	D3DRMLIGHT_AMBIENT, 
	D3DRMLIGHT_POINT, 
	D3DRMLIGHT_SPOT, 
	D3DRMLIGHT_DIRECTIONAL, 
	D3DRMLIGHT_PARALLELPOINT 
}	D3DRMLIGHTTYPE, *LPD3DRMLIGHTTYPE; 
typedef	enum _D3DRMSHADEMODE { 
	D3DRMSHADE_FLAT = 0, 
	D3DRMSHADE_GOURAUD = 1, 
	D3DRMSHADE_PHONG = 2, 
	D3DRMSHADE_MASK = 7, 
	D3DRMSHADE_MAX = 8 
}	D3DRMSHADEMODE, *LPD3DRMSHADEMODE; 
typedef	enum _D3DRMLIGHTMODE { 
	D3DRMLIGHT_OFF = 0 * D3DRMSHADE_MAX, 
	D3DRMLIGHT_ON = 1 * D3DRMSHADE_MAX, 
	D3DRMLIGHT_MASK = 7 * D3DRMSHADE_MAX, 
	D3DRMLIGHT_MAX = 8 * D3DRMSHADE_MAX 
}	D3DRMLIGHTMODE, *LPD3DRMLIGHTMODE; 
typedef	enum _D3DRMFILLMODE { 
	D3DRMFILL_POINTS = 0 * D3DRMLIGHT_MAX, 
	D3DRMFILL_WIREFRAME = 1 * D3DRMLIGHT_MAX, 
	D3DRMFILL_SOLID = 2 * D3DRMLIGHT_MAX, 
	D3DRMFILL_MASK = 7 * D3DRMLIGHT_MAX, 
	D3DRMFILL_MAX = 8 * D3DRMLIGHT_MAX 
}	D3DRMFILLMODE, *LPD3DRMFILLMODE; 
typedef	DWORD D3DRMRENDERQUALITY, *LPD3DRMRENDERQUALITY; 
#define	D3DRMRENDER_WIREFRAME (D3DRMSHADE_FLAT+D3DRMLIGHT_OFF+D3DRMFILL_WIREFRAME) 
#define	D3DRMRENDER_UNLITFLAT (D3DRMSHADE_FLAT+D3DRMLIGHT_OFF+D3DRMFILL_SOLID) 
#define	D3DRMRENDER_FLAT (D3DRMSHADE_FLAT+D3DRMLIGHT_ON+D3DRMFILL_SOLID) 
#define	D3DRMRENDER_GOURAUD (D3DRMSHADE_GOURAUD+D3DRMLIGHT_ON+D3DRMFILL_SOLID) 
#define	D3DRMRENDER_PHONG (D3DRMSHADE_PHONG+D3DRMLIGHT_ON+D3DRMFILL_SOLID) 
typedef	enum _D3DRMTEXTUREQUALITY 
{	D3DRMTEXTURE_NEAREST, 
	D3DRMTEXTURE_LINEAR, 
	D3DRMTEXTURE_MIPNEAREST, 
	D3DRMTEXTURE_MIPLINEAR, 
	D3DRMTEXTURE_LINEARMIPNEAREST,
	D3DRMTEXTURE_LINEARMIPLINEAR 
}	D3DRMTEXTUREQUALITY, *LPD3DRMTEXTUREQUALITY; 
typedef	enum _D3DRMCOMBINETYPE 
{	D3DRMCOMBINE_REPLACE, 
	D3DRMCOMBINE_BEFORE, 
	D3DRMCOMBINE_AFTER 
}	D3DRMCOMBINETYPE, *LPD3DRMCOMBINETYPE; 
typedef	D3DCOLORMODEL D3DRMCOLORMODEL, *LPD3DRMCOLORMODEL; 
typedef	enum _D3DRMPALETTEFLAGS 
{	D3DRMPALETTE_FREE, 
	D3DRMPALETTE_READONLY,
	D3DRMPALETTE_RESERVED
}	D3DRMPALETTEFLAGS, *LPD3DRMPALETTEFLAGS; 
typedef	struct _D3DRMPALETTEENTRY 
{	unsigned char red;
	unsigned char green;
	unsigned char blue; 
	unsigned char flags; 
}	D3DRMPALETTEENTRY, *LPD3DRMPALETTEENTRY; 
typedef	struct _D3DRMIMAGE 
{	int width, height;
	int aspectx, aspecty; 
	int depth;
	int rgb;
	int bytes_per_line; 
	void* buffer1; 
	void* buffer2; 
	unsigned long red_mask; 
	unsigned long green_mask; 
	unsigned long blue_mask; 
	unsigned long alpha_mask;
	int palette_size; 
	D3DRMPALETTEENTRY* palette; 
}	D3DRMIMAGE, *LPD3DRMIMAGE; 
typedef	enum _D3DRMWRAPTYPE 
{	D3DRMWRAP_FLAT, 
	D3DRMWRAP_CYLINDER, 
	D3DRMWRAP_SPHERE, 
	D3DRMWRAP_CHROME 
}	D3DRMWRAPTYPE, *LPD3DRMWRAPTYPE; 
#define	D3DRMWIREFRAME_CULL 1 
#define	D3DRMWIREFRAME_HIDDENLINE 2 
typedef	enum _D3DRMPROJECTIONTYPE 
{	D3DRMPROJECT_PERSPECTIVE, 
	D3DRMPROJECT_ORTHOGRAPHIC 
}	D3DRMPROJECTIONTYPE, *LPD3DRMPROJECTIONTYPE; 
typedef	enum _D3DRMXOFFORMAT 
{	D3DRMXOF_BINARY, 
	D3DRMXOF_COMPRESSED, 
	D3DRMXOF_TEXT 
}	D3DRMXOFFORMAT, *LPD3DRMXOFFORMAT; 
typedef	DWORD D3DRMSAVEOPTIONS; 
#define	D3DRMXOFSAVE_NORMALS 1 
#define	D3DRMXOFSAVE_TEXTURECOORDINATES 2 
#define	D3DRMXOFSAVE_MATERIALS 4 
#define	D3DRMXOFSAVE_TEXTURENAMES 8 
#define	D3DRMXOFSAVE_ALL 15 
#define	D3DRMXOFSAVE_TEMPLATES 16 
typedef	enum _D3DRMCOLORSOURCE 
{	D3DRMCOLOR_FROMFACE, 
	D3DRMCOLOR_FROMVERTEX 
}	D3DRMCOLORSOURCE, *LPD3DRMCOLORSOURCE; 
typedef	enum _D3DRMFRAMECONSTRAINT 
{	D3DRMCONSTRAIN_Z, 
	D3DRMCONSTRAIN_Y, 
	D3DRMCONSTRAIN_X 
}	D3DRMFRAMECONSTRAINT, *LPD3DRMFRAMECONSTRAINT; 
typedef	enum _D3DRMMATERIALMODE 
{	D3DRMMATERIAL_FROMMESH, 
	D3DRMMATERIAL_FROMPARENT, 
	D3DRMMATERIAL_FROMFRAME 
}	D3DRMMATERIALMODE, *LPD3DRMMATERIALMODE; 
typedef	enum _D3DRMFOGMODE 
{	D3DRMFOG_LINEAR, 
	D3DRMFOG_EXPONENTIAL, 
	D3DRMFOG_EXPONENTIALSQUARED 
}	D3DRMFOGMODE, *LPD3DRMFOGMODE; 
	
typedef	enum _D3DRMZBUFFERMODE { 
	D3DRMZBUFFER_FROMPARENT, 
	D3DRMZBUFFER_ENABLE,
	D3DRMZBUFFER_DISABLE 
}	D3DRMZBUFFERMODE, *LPD3DRMZBUFFERMODE; 
typedef	enum _D3DRMSORTMODE { 
	D3DRMSORT_FROMPARENT,
	D3DRMSORT_NONE,
	D3DRMSORT_FRONTTOBACK,
	D3DRMSORT_BACKTOFRONT 
}	D3DRMSORTMODE, *LPD3DRMSORTMODE; 
typedef	DWORD D3DRMANIMATIONOPTIONS; 
#define	D3DRMANIMATION_OPEN 1 
#define	D3DRMANIMATION_CLOSED 2 
#define	D3DRMANIMATION_LINEARPOSITION 4 
#define	D3DRMANIMATION_SPLINEPOSITION 8 
#define	D3DRMANIMATION_SCALEANDROTATION 16 
#define	D3DRMANIMATION_POSITION 32 
typedef	DWORD D3DRMLOADOPTIONS; 
#define	D3DRMLOAD_FROMFILE 0x00L 
#define	D3DRMLOAD_FROMRESOURCE 0x01L 
#define	D3DRMLOAD_FROMMEMORY 0x02L 
#define	D3DRMLOAD_FROMSTREAM 0x04L 
#define	D3DRMLOAD_BYNAME 0x10L 
#define	D3DRMLOAD_BYPOSITION 0x20L 
#define	D3DRMLOAD_BYGUID 0x40L 
#define	D3DRMLOAD_FIRST 0x80L 
#define	D3DRMLOAD_INSTANCEBYREFERENCE 0x100L 
#define	D3DRMLOAD_INSTANCEBYCOPYING 0x200L 
typedef	struct _D3DRMLOADRESOURCE { 
	HMODULE hModule; 
	LPCTSTR lpName; 
	LPCTSTR lpType; 
}	D3DRMLOADRESOURCE, *LPD3DRMLOADRESOURCE; 
typedef	struct _D3DRMLOADMEMORY { 
	LPVOID lpMemory; 
	DWORD dSize; 
}	D3DRMLOADMEMORY, *LPD3DRMLOADMEMORY; 
typedef	enum _D3DRMUSERVISUALREASON { 
	D3DRMUSERVISUAL_CANSEE, 
	D3DRMUSERVISUAL_RENDER 
}	D3DRMUSERVISUALREASON, *LPD3DRMUSERVISUALREASON; 
typedef	DWORD D3DRMMAPPING, D3DRMMAPPINGFLAG, *LPD3DRMMAPPING; 
static	const D3DRMMAPPINGFLAG D3DRMMAP_WRAPU = 1; 
static	const D3DRMMAPPINGFLAG D3DRMMAP_WRAPV = 2; 
static	const D3DRMMAPPINGFLAG D3DRMMAP_PERSPCORRECT = 4; 
typedef	struct _D3DRMVERTEX 
{	D3DVECTOR position; 
	D3DVECTOR normal; 
	D3DVALUE tu, tv; 
	D3DCOLOR color; 
}	D3DRMVERTEX, *LPD3DRMVERTEX; 
typedef	LONG D3DRMGROUPINDEX; 
static	const D3DRMGROUPINDEX D3DRMGROUP_ALLGROUPS = -1; 
extern	D3DCOLOR D3DRMAPI D3DRMCreateColorRGB(D3DVALUE,D3DVALUE,D3DVALUE); 
extern	D3DCOLOR D3DRMAPI D3DRMCreateColorRGBA(D3DVALUE,D3DVALUE,D3DVALUE,D3DVALUE); 
extern	D3DVALUE D3DRMAPI D3DRMColorGetRed(D3DCOLOR); 
extern	D3DVALUE D3DRMAPI D3DRMColorGetGreen(D3DCOLOR); 
extern	D3DVALUE D3DRMAPI D3DRMColorGetBlue(D3DCOLOR); 
extern	D3DVALUE D3DRMAPI D3DRMColorGetAlpha(D3DCOLOR); 
extern	LPD3DVECTOR D3DRMAPI D3DRMVectorAdd(LPD3DVECTOR,LPD3DVECTOR,LPD3DVECTOR); 
extern	LPD3DVECTOR D3DRMAPI D3DRMVectorSubtract(LPD3DVECTOR,LPD3DVECTOR,LPD3DVECTOR); 
extern	LPD3DVECTOR D3DRMAPI D3DRMVectorReflect(LPD3DVECTOR,LPD3DVECTOR,LPD3DVECTOR); 
extern	LPD3DVECTOR D3DRMAPI D3DRMVectorCrossProduct(LPD3DVECTOR,LPD3DVECTOR,LPD3DVECTOR); 
extern	D3DVALUE D3DRMAPI D3DRMVectorDotProduct(LPD3DVECTOR,LPD3DVECTOR); 
extern	LPD3DVECTOR D3DRMAPI D3DRMVectorNormalize(LPD3DVECTOR); 
#define	D3DRMVectorNormalise D3DRMVectorNormalize 
extern	D3DVALUE D3DRMAPI D3DRMVectorModulus(LPD3DVECTOR); 
extern	LPD3DVECTOR D3DRMAPI D3DRMVectorRotate(LPD3DVECTOR,LPD3DVECTOR,LPD3DVECTOR,D3DVALUE); 
extern	LPD3DVECTOR D3DRMAPI D3DRMVectorScale(LPD3DVECTOR,LPD3DVECTOR,D3DVALUE); 
extern	LPD3DVECTOR D3DRMAPI D3DRMVectorRandom(LPD3DVECTOR); 
extern	LPD3DRMQUATERNION D3DRMAPI D3DRMQuaternionFromRotation(LPD3DRMQUATERNION,LPD3DVECTOR,D3DVALUE); 
extern	LPD3DRMQUATERNION D3DRMAPI D3DRMQuaternionMultiply(LPD3DRMQUATERNION,LPD3DRMQUATERNION,LPD3DRMQUATERNION); 
extern	LPD3DRMQUATERNION D3DRMAPI D3DRMQuaternionSlerp(LPD3DRMQUATERNION,LPD3DRMQUATERNION,LPD3DRMQUATERNION,D3DVALUE); 
extern	void D3DRMAPI D3DRMMatrixFromQuaternion(D3DRMMATRIX4D,LPD3DRMQUATERNION); 
#endif	
