/*
 * File: aerowgs84.hpp
 *
 * Abstract:
 *
 *      Data specific to continuous World Geodetic System (WGS 84) Earth 
 *      gravity.
 *
 *  S. Gage, 16 FEB 2006
 *  Copyright 1990-2013 The MathWorks, Inc.
 *
 */

#define A      6378137.0          /* Semi-major Axis (m) */ 
#define INV_F  298.257223563      /* Reciprocal of Flattening */    
#define W_DEF  7292115.0e-11      /* WGS 84 Angular Velocity of Earth (rad/sec)*/ 
#define GM_DEF 3986004.418e+8     /* Earth's Gravitational Const. (m^3/sec^2) */ 
#define GM_PRM 3986000.9e+8       /* Earth's Grav. Const. (m^3/sec^2) [no atmos]*/
#define W_PRM  7292115.1467e-11   /* IAU Angular Velocity of Earth (rad/sec) */
#define G_E    9.7803253359       /* Theoretical (Normal) Gravity at the Equator 
                                 (on the Ellipsoid) (m/s^2) */
#define K      0.00193185265241   /* Theoretical (Normal) Gravity Formula Const.*/
#define E_2    6.69437999014e-3   /* First Eccentricity Squared */
#define EL     5.2185400842339e+5 /* Linear Eccentricity */
#define B      6356752.3142       /* Semi-minor Axis (m) */
#define B_A    0.996647189335     /* Axis Ratio */

