/* Copyright 2013 The MathWorks, Inc. */
#include <coder/target_services/Application.hpp>
#include <coder/target_services/TargetMessages.hpp>
#include <coder/target_services/StatusFlags.hpp>

namespace coder { namespace tgtsvc {

Application *Application::registry_[APPLICATION_COUNT] = { NULL, NULL};

Application *Application::findById(uint8_t id)
{
    return registry_[id];
}

void Application::dispatch(Message *message)
{
    uint8_t destId = message->header().appId_;
    assert(destId < APPLICATION_COUNT);
    Application *dest = registry_[destId];
    if (dest) {
        dest->handleMessage(message);
    } else {
        delete message;
        StatusFlags::instance().set(StatusFlags::MSG_APP_ID_OUT_OF_RANGE);
    }
}

void Application::connectionChanged(bool connected)
{
    for (uint8_t id=1; id<APPLICATION_COUNT; ++id) {
        if (registry_[id] != NULL) {
            registry_[id]->handleConnect(connected);
        }
    }
}

}}
