/* Copyright 2009-2012 The MathWorks, Inc. */

#include "host_timer_x86.h"

/* Use the rdtsc instruction to access the time stamp counter (all x86
 * processors).  This instruction moves the contents of the 64-bit timer to
 * e.g. the %eax, %edx registers. For functions returning a 32-bit type,
 * only the contents of the %eax register are used. For functions returning
 * a 64-bit type, the content of both %eax and %edx registers is used.
 */
    
/* Function returning a 64-bit timer value */
uint64_T timestamp_x86(void) 
{

#if defined(__GNUC__ )
#   ifndef __x86_64
#        error For gcc, the assembler is valid for only for 64-bit architectures.
#   endif
    union {
        uint64_T big;
        struct {
            uint32_T lo;
            uint32_T hi;
        } small;
    } ret;
    __asm__ volatile ("rdtsc"
                      : "=a"(ret.small.lo), "=d"(ret.small.hi)  /* Specify registers 
                                                                 * that contain the 
                                                                 * captured value of the 
                                                                 * timestamp counter */
        );
    return ret.big;
     
# elif defined(_MSC_VER)

#if _MSC_VER <= 1200 /* MSVC 6.0 or lower */
    __asm rdtsc
#else
    return (uint64_T) __rdtsc();
#endif
    
# else

#   error("Unsupported compiler")

# endif


}
