/* Copyright 2011 The MathWorks, Inc. */
#include "code_coverage_utils.h"

/* COV_MAX_SOURCE_MODULES is set by cov.LDRA and 
 * is an upper bound on the number of instrumented 
 * source files in the application.
 *
 * If the application tries to register more than
 * COV_MAX_SOURCE_MODULES upload functions then these 
 * extra functions will be ignored. */
static targetUploadFcn uploadFcns[COV_MAX_SOURCE_MODULES];
static int nextFreeUploadFunc = 0;

void registerTargetUploadFcn(targetUploadFcn aUploadFcn) {
   static int firstTime = 1;
   if (firstTime) {
      /* initialize function pointers */
      int i;
      for (i=0; i<COV_MAX_SOURCE_MODULES; i++) {
         uploadFcns[i] = 0;
      }
      firstTime = 0;
   }
   if (nextFreeUploadFunc < COV_MAX_SOURCE_MODULES) {
      /* checking for duplicates is not necessary
       * as each module has a static variable 
       * isRegistered to ensure no duplications */
      uploadFcns[nextFreeUploadFunc++] = aUploadFcn;  
   }
}

void callTargetUploadFcns(void) {
   int i;
   for (i=0; i<nextFreeUploadFunc; i++) {
      (*uploadFcns[i])();
   }
}
