var mypath ="";
var grid;
var myfacade;

var mydata = [
    {id:1,name:"ShowRTWWidgets",value:"on",status:0,prompt:"RTW:configSet:ConfigSetShowRTWWidgetsName",type:"boolean"},
    {id:2,name:"StartTime",value:"4",status:0,prompt:"Start time:",type:"string"},
    {id:3,name:"StopTime",value:"10.0",status:0,prompt:"Stop time:",type:"string"},
    {id:4,name:"SolverType",value:"Variable-step",status:0,prompt:"Type:",type:"enum",options:[{value:"Variable-step",label:"Variable-step"},{value:"Fixed-step",label:"Fixed-step"}]},
]

function init() {
    grid.renderArray(mydata);
}

function callback(id, data) {
    mydata[id-1].value = data.value;
    myfacade.publish(mypath+"/callback", JSON.stringify(data));
}

function establishConnection(path) {
    mypath = path;
    var update = myfacade.subscribe(mypath+"/update", function (message) {
        var p = JSON.parse(message.data);
        mydata[p.id-1] = p;
        var w = dijit.registry.byId(p.name);
        if (w) {
            if (w.type == "checkbox") {
                w.set("checked", p.value, false);
            } else {
                w.set("value", p.value, false);
            }
            w.set("disabled", p.status != 0);
        }
    });
    
    var init = myfacade.subscribe(mypath+"/init", function (message) {
        mydata = JSON.parse(message.data);
        grid.refresh();
        grid.renderArray(mydata);
    });

    var refresh = myfacade.subscribe(mypath+"/refresh", function (message) {
        mydata = JSON.parse(message.data);
        var x = grid.bodyNode.scrollLef;
        var y = grid.bodyNode.scrollTop;
        grid.refresh();
        grid.renderArray(mydata);
        grid.scrollTo({x:x, y:y})
    });

    myfacade.publish(mypath, "ready");

}


require([
    "MW/facade/MatlabFacade",
    "dojo/domReady!"
], function(MatlabFacade){
    myfacade = new MatlabFacade();

});


require([
    "dgrid/Grid", "dojo/domReady!", "dojo/parser", "dgrid/extensions/ColumnResizer",
    "dijit/form/Select","dijit/form/TextBox","dijit/form/CheckBox", "dijit/form/NumberSpinner", "dijit/Tooltip"
], function(Grid, parser, Select, ColumnResizer, TextBox, CheckBox, NumberSpinner, Selection){
    
    var MyGrid = dojo.declare([Grid, ColumnResizer]);
 
    var mycols = [
        {label: "ID", field: "id", sortable: true},
        {label: "Parameter", field: "name", renderCell: actionRenderName, sortable: true},
        {label: "Value", field: "value", renderCell: actionRenderValue, sortable: true},
    ];

    function actionRenderName(object, data, cell) {
        name = '<div class="name">' + object.name + '</div>';
        prompt = '<div class="prompt">' + object.prompt; + '</div>';
        cell.innerHTML = '<div class="param" id="'+object.name+'_param">' + name + '<br>' + prompt + '</div>';

    }

    function actionRenderValue (object, data, cell) {
        var w = dijit.registry.byId(object.name);
        if (w) {
            // w.setValue(object.value);
            // w.setDisabled(object.status != 0);
        } else {
            switch (object.type) {
            case "enum":
                w = new dijit.form.Select({id:object.name, value:object.value, options:object.options,style:{width:'100px'}});
                dojo.connect(w, "onChange", function () {callback(object.id, {name:w.id, value:w.value});});
                break;
            case "int":
                w = new dijit.form.TextBox({id:object.name, value:object.value});
                dojo.connect(w, "onChange", function () {callback(object.id, {name:w.id, value:w.value});});
                break;
            case "boolean":
                w = new dijit.form.CheckBox({id:object.name, checked:object.value});
                dojo.connect(w, "onChange", function () {callback(object.id, {name:w.id, value:w.checked});});
                break;
            case "string":
                w = new dijit.form.TextBox({id:object.name, value:object.value});
                dojo.connect(w, "onChange", function () {callback(object.id, {name:w.id, value:w.value});});
                break;
            case "minmax":
                w = new dijit.form.NumberSpinner({id:object.name, value:object.value, constraints:{min:object.min, max:object.max}});
                dojo.connect(w, "onChange", function () {callback(object.id, {name:w.id, value:w.value});});
                break;
            default:
                w = new dijit.form.TextBox({id:object.name, value:"###"});
                dojo.connect(w, "onChange", function () {callback(object.id, {name:w.id, value:w.value});});
            }
            
            w.set("disabled", object.status != 0);
            new dijit.Tooltip({
                id: w.id + "_tooltip",
                connectId: w.id,
                label: w.id
            });
            
        }
        
        w.placeAt(cell);

    }

    
    grid = new MyGrid({
        getBeforePut: false,
        columns: mycols
    }, "grid");

    grid.on("dgrid-select")
    // grid.renderArray(mydata);
    
});



