<!DOCTYPE html>
<html>
	<head>
		<title>dTuned</title>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta name="viewport" content="width=570">
		<link rel="stylesheet" href="../../js/dojo/resources/dojo.css">
		<link rel="stylesheet" href="resources/dTuned.css">
		<style>
			html, body {
				width: 100%;
				height: 100%;
				overflow: hidden;
			}
			body {
				font-family: "Lucida Grande", sans-serif;
				font-size: 11px;
				position: relative;
			}
			#header {
				position: relative;
				height: 64px;
				background-image: url(resources/images/header-background.png);
				background-repeat: repeat-x;
			}
			#header-content {
				position: absolute;
				top: 10px;
				left: 50%;
				width: 431px;
				height: 45px;
				margin-left: -215px;
				font-size: 18px;
				font-weight: bold;
				text-align: center;
				padding-top: 12px;
				background-image: url(resources/images/header.png);
				background-repeat: no-repeat;
			}
			#list-container {
				position: absolute;
				top: 65px;
				left: 0;
				right: 0;
				height: 120px;
			}

			/* styles for the three lists in the top region */
			#genres, #artists, #albums {
				position: absolute;
				top: 0;
				bottom: 0;
				width: 33.3%;
				height: auto;
			}
			#list-container .dgrid-row { /* all rows in all 3 lists */
				padding: 0.25em;
				cursor: default;
			}

			/* IE<7 doesn't support height/width: auto w/ top/bottom / left/right. */
			.has-ie-6 #genres, .has-ie-6 #artists, .has-ie-6 #albums {
				height: 120px;
			}
			.has-ie-6 #list-container {
				width: 100%;
			}

			#artists { left: 33.3%; }
			#albums { right: 0; }

			#grid {
				position: absolute;
				left: 0;
				right: 0;
				top: 187px;
				bottom: 0;
				height: auto; /* override default height: 30em; in dgrid.css */
			}
			
			.has-ie-6 #grid {
				width: 100%;
				/* Give the grid a height.  Not optimal, but we'd need more JS for better. */
				height: 20em;
			}
			
			#grid .dgrid-cell {
				border: 0;
			}
			#grid .dgrid-header th {
				border: 0;
				border-right: 1px solid #a6a6a6;
			}
			#grid .dgrid-header th:last-child {
				border: 0;
			}
			#grid .dgrid-row-even {
				background-color: #f2f6fa;
			}
			#grid .dgrid-row-even.dgrid-selected {
				background-color: #bfd6eb;
			}

			#grid .field-Time,
			#grid .field-Year { 
				text-align: right; 
			}
			
			.backTo {
				position:absolute;
				top:15px;
				left:10px;
			}
		</style>
		<script type="text/javascript" src="../../js/dojo/dojo.js" 
			data-dojo-config="async: true"></script>
		<script type="text/javascript">
			function unique(arr){
				//	create a unique list of items from the passed array
				//	(removing duplicates).  This is quick and dirty.

				//	first, set up a hashtable for unique objects.
				var obj = {};
				for(var i=0,l=arr.length; i<l; i++){
					if(!(arr[i] in obj)){
						obj[arr[i]] = true;
					}
				}

				//	now push the unique objects back into an array, and return it.
				var ret = [];
				for(var p in obj){
					ret.push(p);
				}
				ret.sort();
				return ret;
			}

			//	our "main" function
			require([
					"dgrid/List",
					"dgrid/OnDemandGrid",
					"dgrid/Selection",
					"dgrid/Keyboard",
					"dgrid/extensions/ColumnHider",
					"dojo/_base/declare",
					"dojo/_base/array",
					"dgrid/demos/dTuned/data",
					"dojo/domReady!"
				],
				function(List, Grid, Selection, Keyboard, Hider, declare, arrayUtil){
					//	a formatting function for the Duration column.
					var timeFormatter = function(t){
						var tmp = parseInt(t, 10), min, sec;
						if(isNaN(tmp)){ return t; }
						min = Math.floor(tmp/60);
						sec = tmp % 60;
						// don't forget to pad seconds.
						return "" + min + ":" + (sec < 10 ? "0" : "") + sec;
					};

					// Create the main grid to appear below the genre/artist/album lists.
					window.grid = new (declare([Grid, Selection, Keyboard, Hider]))({
						store: songStore,
						columns: {
							Name: "Name",
							Time: { label: "Duration", formatter: timeFormatter },
							Year: "Year",
							Artist: "Artist",
							Album: "Album",
							Genre: "Genre"
						}
					}, "grid");

					// define a List constructor with the features we want mixed in,
					// for use by the three lists in the top region
					var TunesList = declare([List, Selection, Keyboard]);

					//	define our three lists for the top.
					window.genres = new TunesList({ selectionMode: "single" }, "genres");
					window.artists = new TunesList({ selectionMode: "single" }, "artists");
					window.albums = new TunesList({ selectionMode: "single" }, "albums");

					//	create the unique lists and render them
					var g = unique(arrayUtil.map(songStore.data, function(item){ return item.Genre; })),
						art = unique(arrayUtil.map(songStore.data, function(item){ return item.Artist; })),
						alb = unique(arrayUtil.map(songStore.data, function(item){ return item.Album; }));
					g.unshift("All (" + g.length + " Genre" + (g.length != 1 ? "s" : "") + ")");
					art.unshift("All (" + art.length + " Artist" + (art.length != 1 ? "s" : "") + ")");
					alb.unshift("All (" + alb.length + " Album" + (alb.length != 1 ? "s" : "") + ")");
					genres.renderArray(g);
					artists.renderArray(art);
					albums.renderArray(alb);

					var currentGenre; // updated on genre select

					//	start listening for selections on the lists.
					genres.on("dgrid-select", function(e){
						//	filter the albums, artists and grid
						var
							row = e.rows[0],
							filter = currentGenre = row.data,
							art;
						if(row.id == "0"){
							//	remove filtering
							art = unique(arrayUtil.map(songStore.data, function(item){ return item.Artist; }));
							grid.query = {};
						} else {
							//	create filtering
							art = unique(arrayUtil.map(arrayUtil.filter(songStore.data, function(item){ return item.Genre == filter; }), function(item){ return item.Artist; }));
							grid.query = { "Genre": filter };
						}
						art.unshift("All (" + art.length + " Artist" + (art.length != 1 ? "s" : "") + ")");
						
						artists.refresh();	//	clear contents
						artists.renderArray(art);
						artists.select(0); //	reselect "all", triggering albums+grid refresh
					});

					artists.on("dgrid-select", function(e){
						//	filter the albums, grid
						var row = e.rows[0],
							filter = row.data, alb;
						if(row.id == "0"){
							if(genres.selection[0]){
								//	remove filtering entirely
								alb = unique(arrayUtil.map(songStore.data, function(item){ return item.Album; }));
							} else {
								//	filter only by genre
								alb = unique(arrayUtil.map(arrayUtil.filter(songStore.data, function(item){ return item.Genre == currentGenre; }), function(item){ return item.Album; }));
							}
							delete grid.query.Artist;
						} else {
							//	create filter based on artist
							alb = unique(arrayUtil.map(arrayUtil.filter(songStore.data, function(item){ return item.Artist == filter; }), function(item){ return item.Album; }));
							grid.query.Artist = filter;
						}
						alb.unshift("All (" + alb.length + " Album" + (alb.length != 1 ? "s" : "") + ")");

						albums.refresh(); //	clear contents
						albums.renderArray(alb);
						albums.select(0); //	reselect "all" item, triggering grid refresh
					});

					albums.on("dgrid-select", function(e){
						//	filter the grid
						var row = e.rows[0],
							filter = row.data;
						if(row.id == "0"){
							// show all albums
							delete grid.query.Album;
						} else {
							grid.query.Album = filter;
						}
						grid.refresh();
					});

					//	set the initial selections on the lists.
					genres.select(0);

				}	//	end "main" function
			);	//	end require
		</script>

	</head>
	<body class="dTuned">
		<div id="header">
			<a href="../../#demos" class="backTo"><img src="resources/images/backToDgrid.png" /></a>
			<div id="header-content">
				dTuned
			</div>
		</div>
		<div id="list-container">
			<div id="genres"></div>
			<div id="artists"></div>
			<div id="albums"></div>
		</div>
		<div id="grid"></div>
	</body>
</html>
