// The path to the Web Widgets source
// Can we pass in Web Widget version number as a parameter to the build?
var webWidgetBasePath = "../../../ui/webwidgets/src/";

// Will only see these log statements if using Node.js to do the build.
// Configure build runner, java or node, through the dojo/build.sh --bin
// command line arg
// console.log("webWidgetBasePath is '" + webWidgetBasePath + "'");

// Regex to tell build not to search CVS folders
var excludeCvsPaths = [[ ".", ".", /(\/\.)|(~$)|(CVS)/ ]];

var profile = {
    // Set the path from which dojo calculates all other relative paths. Set here
    // to the directory containing this file.
    basePath: ".",

    // The folder name containing the UI code processed by this build
    // configuration. It will copy all the source files here before processing
    // them.
    releaseName: "addons-working",

    // The directory where dojo will place all the built artifacts
    releaseDir: "./release",

    // Remove comments from CSS files
    cssOptimize: "comments",

    // The CSS selector engine built into the code
    selectorEngine: "acme",

    // Configuration flag for Web Widgets
    buildingInBaT: true,

    staticHasFeatures: {
        'dojo-bidi': false //We do not support Bi-Directional (Right to Left) Interfaces - remove the support
    },

    // The location of top level packages declared as dependencies in the UI
    // code. You'll see these in the AMD define() function. For example:
    // 		define(["dojo/store/Memory", "dijit/Dialog", "MW/Log"], function(...
    packages: [{
        name: "dojo",
        location: webWidgetBasePath + "js/dojo/dojo",
        trees: excludeCvsPaths
    }, {
        name: "dijit",
        location: webWidgetBasePath + "js/dojo/dijit",
        trees: excludeCvsPaths
    }, {
        name: "dojox",
        location: webWidgetBasePath + "js/dojo/dojox",
        trees: excludeCvsPaths
    }, {
        name: "MW",
        location: webWidgetBasePath + "js/MW",
        trees: excludeCvsPaths
    }, {
        name: "l10n",
        location: webWidgetBasePath + "l10n",
        trees: excludeCvsPaths
    }, {
        name: "addons",
        location: "js",
        trees: excludeCvsPaths
    }, {
        name: "l10n-addons",
        location: "l10n-addons",
        trees: excludeCvsPaths
    }, {
        name: "images-addons",
        location: "images-addons",
        trees: excludeCvsPaths
    }, {
        name: "css-addons",
        location: "css-addons",
        trees: excludeCvsPaths
    }, {
        name: "templates-addons",
        location: "templates-addons",
        trees: excludeCvsPaths
    }
    ],

    // The JavaScript code will get minimized into layer files. dojo generates
    // files to: [releaseDir]/[package name]/[layer file name].
    layers: {
        "addons/addons": {
            copyright: "copyright.txt",
            include: [
                // Add your main application modules first
                "addons/AddonsBrowser/GetAddonsPageLoad",
                "addons/AddonsManager/ManagerPageLoad",
                // Include Web Widget modules here
                "MW/remote/Remote",
                "MW/remote/MessageService",
                "dojo/dom",
                "dojo/domReady",
                "dojo/_base/declare",
                "dojo/_base/array",
                "dojo/io-query",
                "dojo/i18n",
                "dojo/dom-style",
                "dojo/_base/fx",
                "dojo/_base/lang",
                "dojo/on",
                "dojo/mouse",
                "dojo/text",

                // Add in required dijit modules
                "dijit/main",
                "dijit/_base",
                "dijit/_base/manager",
                "dijit/_WidgetBase",
                "dijit/_TemplatedMixin"
            ],
            exclude: [
                "addons/browsercheck"
            ]
        },

        "addons/browsercheck": {
            copyright: "copyright.txt",
            include: [
                "dojo/require",
                "dijit/main",
                "dojox/main",
                "MW/utils/BrowserCheck"
            ]
        }
    }
};