/* Copyright 2013 The MathWorks, Inc. */

/* 
 * File: rx_tx_buffer_sizes.h
 *
 * Defines the buffer sizes for the various XIL services.
 * Make sure we are backwards compatible with PIL implementations that 
 * define RTIOSTREAM_TX_BUFFER_BYTE_SIZE and RTIOSTREAM_RX_BUFFER_BYTE_SIZE
 * in their connectivity config. We will use these preprocessor defines to
 * derive both the RX and TX buffer sizes for the various XIL services and
 * make sure we don't incur more memory requirements.
 */		

#ifndef __RX_TX_BUFFER_SIZES_H__
#define __RX_TX_BUFFER_SIZES_H__

#include "rtwtypes.h"

/* transmit buffer size in mem units - no need to worry about fractions 
 * as division in C always floors the result. 
 */
#define RTIOSTREAM_TX_BUFFER_MEMUNIT_SIZE (RTIOSTREAM_TX_BUFFER_BYTE_SIZE / MEM_UNIT_BYTES)

/* Receive buffer size for the comm service */
#define COMMSERVICE_RX_BUFFER_MEMUNIT_SIZE (RTIOSTREAM_RX_BUFFER_BYTE_SIZE / MEM_UNIT_BYTES)

/* send buffer sizes for XIL and Code Instrumentation applications */
#ifndef CODE_INSTRUMENTATION_ENABLED
#define XIL_TX_BUFFER_MEMUNIT_SIZE RTIOSTREAM_TX_BUFFER_MEMUNIT_SIZE
#else
#define XIL_TX_BUFFER_MEMUNIT_SIZE (RTIOSTREAM_TX_BUFFER_MEMUNIT_SIZE/2)
#define CODE_INSTR_TX_BUFFER_MEMUNIT_SIZE XIL_TX_BUFFER_MEMUNIT_SIZE
#endif

#define APPLICATION_ID_SIZE (sizeof(MemUnit_T))
#define WRITE_DATA_AVAIL_SIZE (sizeof(uint32_T))
#define BUFFER_HEADER_SIZE  (APPLICATION_ID_SIZE + WRITE_DATA_AVAIL_SIZE)

#endif /*__RX_TX_BUFFER_SIZES_H__ */

