/* Copyright 2007-2014 The MathWorks, Inc. */

/* 
 * File: xil_data_stream.h
 */

#ifndef __XIL_DATA_STREAM_H__
#define __XIL_DATA_STREAM_H__

#include "xil_common.h"
#include "xil_error_codes.h"

#define COMMAND_COMPLETE_SIZE (sizeof(MemUnit_T))
#define COMMAND_COMPLETE_IDX 0
#define WRITE_DATA_BUFFER_IDX (COMMAND_COMPLETE_IDX + COMMAND_COMPLETE_SIZE)

/* copy specified amount of data from the address specified to the output stream */
XIL_DATA_STREAM_ERROR_CODE xilWriteData(const MemUnit_T *, uint32_T);
/* flush any buffered writes */
XIL_DATA_STREAM_ERROR_CODE xilDataFlush(MemUnit_T isEndOfXILStep);
       
#ifdef CODE_INSTRUMENTATION_ENABLED
/* copy specified amount of data from the address specified to the output stream */
XIL_DATA_STREAM_ERROR_CODE codeInstrWriteData(const MemUnit_T *, uint32_T);
/* flush any buffered writes */
XIL_DATA_STREAM_ERROR_CODE codeInstrDataFlush(void);
#endif

#endif
