// The path to the Web Widgets source
// Can we pass in Web Widget version number as a parameter to the build?
var webWidgetBasePath = "../../../../../../ui/webwidgets/src/";

// Will only see these log statements if using Node.js to do the build.
// Configure build runner, java or node, through the dojo/build.sh --bin
// command line arg
// console.log("webWidgetBasePath is '" + webWidgetBasePath + "'");

// Regex to tell build not to search CVS folders
var excludeCvsPaths = [[ ".", ".", /(\/\.)|(~$)|(CVS)/ ]];

var profile = {
	// Set the path from which dojo calculates all other relative paths. Set here
    // to the directory containing this file.
    basePath: ".",

    // The folder name containing the UI code processed by this build
    // configuration. It will copy all the source files here before processing
    // them.
    releaseName: "cswebview-working",

    // The directory where dojo will place all the built artifacts
    releaseDir: "./release",

    // Remove comments from CSS files
    cssOptimize: "comments",

    // The CSS selector engine built into the code
    selectorEngine: "acme",
    
    // Configuration flag for Web Widgets
    buildingInBaT: true,
	
	staticHasFeatures: { 
		'dojo-bidi': false, //We do not support Bi-Directional (Right to Left) Interfaces - remove the support
	},

  	// The location of top level packages declared as dependencies in the UI
    // code. You'll see these in the AMD define() function. For example:
  	// 		define(["dojo/store/Memory", "dijit/Dialog", "MW/Log"], function(...
    packages: [{
			name: "dojo",
			location: webWidgetBasePath + "js/dojo/dojo",
			// Exclude CVS folders from scanning
			trees: excludeCvsPaths
        }, {
            name: "dijit",
            location: webWidgetBasePath + "js/dojo/dijit",
            // Exclude CVS folders from scanning
            trees: excludeCvsPaths
        }, {
            name: "dojox",
            location: webWidgetBasePath + "js/dojo/dojox",
            // Exclude CVS folders from scanning
            trees: excludeCvsPaths
        }, {
            name: "MW",
            location: webWidgetBasePath + "js/MW",
            // Exclude CVS folders from scanning
            trees: excludeCvsPaths
        }, {
            name: "l10n",
            location: webWidgetBasePath + "l10n",
            // Exclude CVS folders from scanning
            trees: excludeCvsPaths
        }, {
            name: "cswebview",
            location: "js",
            // Exclude CVS folders from scanning
            trees: excludeCvsPaths
        }, {
            name: "images-cswebview",
            location: "images-cswebview",
            // Exclude CVS folders from scanning
            trees: excludeCvsPaths
        }, {
            name: "images",
            location: webWidgetBasePath + "images",
            // Exclude CVS folders from scanning
            trees: excludeCvsPaths
        }, {
            name: "css-cswebview",
            location: "css-cswebview",
            // Exclude CVS folders from scanning
            trees: excludeCvsPaths
        }, {
            name: "css",
            location: webWidgetBasePath + "css",
            // Exclude CVS folders from scanning
            trees: excludeCvsPaths
        }, {
            name: "fonts",
            location: webWidgetBasePath + "fonts",
            // Exclude CVS folders from scanning
            trees: excludeCvsPaths
        }, {
            name: "dgrid",
            location: webWidgetBasePath + "js/dgrid",
            // Exclude CVS folders from scanning
            trees: excludeCvsPaths
        },{
            name: "put-selector",
            location: webWidgetBasePath + "js/put-selector",
            // Exclude CVS folders from scanning
            trees: excludeCvsPaths
        },{
            name: "xstyle",
            location: webWidgetBasePath + "js/xstyle",
            // Exclude CVS folders from scanning
            trees: excludeCvsPaths
        }
    ],

    // The JavaScript code will get minimized into layer files. dojo generates
    // files to: [releaseDir]/[package name]/[layer file name].
    layers: {
        "cswebview/cswebview": {
            copyright: "copyright.txt",
            include: [
              // Add your main application modules first
			  "cswebview/app/Main",
			  "dojo/dom",
			  "dojo/domReady",
              
              // Include Web Widget modules here
              "MW/remote/Remote",
              "MW/facade/MatlabFacade",

			  // Add in required dojo modules              
              "dojo/dnd/AutoSource",
              "dojo/dnd/Target",

			  // Add in required dijit modules              
              "dijit/main",
              "dijit/_base",
              "dijit/_base/manager",
			  "dijit/form/DropDownButton",
			  "dijit/form/ComboButton",
			  "dijit/form/ToggleButton",

                // add dgrid
                "dgrid/TouchScroll",
                "dgrid/util/touch",
                "dgrid/tree",
                "dgrid/extensions/_DnD-touch-autoscroll",
                "xstyle/css",
                "xstyle/core/load-css",

                
            ],
            exclude: [
              "cswebview/browsercheck"
            ]
        },

        "cswebview/browsercheck": {
            copyright: "copyright.txt",
            include: [
                "dojo/require",
                "dijit/main",
                "dojox/main",
                "MW/utils/BrowserCheck"
            ]
        }
    }
};
