ITK Community Participation Guidelines
======================================

Version 1.0 – Updated January, 2018

The [Insight Software Consortium](http://www.insightsoftwareconsortium.org/)
(ISC) as the copyright holder of the National Library of Medicine Insight
Segmentation and Registration Toolkit (ITK) has adopted the following Code of
Conduct for ITK.

Purpose
-------

The primary goal of the ITK community is to be inclusive of the largest number
of contributors, with the most varied and diverse backgrounds. Please read our
[Motivation](Motivation.md) statement.

Our community is build upon [values](#our-values), and we welcome and encourage
members to [lead by example](#lead-by-example). However, we are aware that we
must ensure a safe, welcoming and productive environment, where all people
should feel safe to participate, introduce new ideas and inspire others. Hence,
we acknowledge the importance of providing mechanisms for participants to
[report](Reporting.md) [unacceptable behavior](#unacceptable-behavior), and the
responsibility of the community to [enforce](Enforcement.md) these guidelines.

Our Values
----------

The following behaviors are expected of all ITK community members:

### Be open

We invite anyone to participate in our community. We are accepting of all who
wish to take part in our activities, fostering an environment where anyone can
participate and everyone can make a difference. Members of the community are
expected to be open to collaboration in any aspect of the project, whether it's
on

  * developing cutting-edge features,
  * fixing bugs,
  * improving documentation,
  * adding examples or or enhancing the existing ones,
  * improving the testing framework,
  * enhancing the code coverage,
  * improving the ITK ecosystem with new tools,
  * hosting ISC-endorsed events,
  * or otherwise.

We are receptive to constructive comment and criticism; gracefully accept
others' advice, as the experiences and skill sets of other members contribute
to the whole of our efforts.

Remember that we are different. The strength of our community comes from its
diversity, people from a wide range of backgrounds. Different people have
different perspectives on issues, and all of them may help in finding the most
appropriate solution in each situation.

We prefer to use public methods of communication for project-related messages,
unless discussing something sensitive (e.g. potential conflicts of interest).
This applies to messages for help or project-related support, too; not only is
a public support request much more likely to result in an answer to a question,
it also ensures that any inadvertent mistakes in answering are more easily
detected and corrected. Please avoid seeking for help privately; asking in the
official ITK discussion forums will increase your chances of getting an answer.

### Be welcoming

We strive to be a community that welcomes and supports people of all
backgrounds and identities. Be positive and engaging. Refrain from being
snarky.

If someone asks for help, it is because they need it. Politely suggest specific
documentation or more appropriate venues where adequate. Avoid aggressive or
vague responses.

### Be inclusive

Seek diverse perspectives. Diversity of views and of people on teams powers
innovation, even if it is not always comfortable. Encourage all voices. Help
new perspectives be heard and listen actively. If you find yourself dominating
a discussion, it is especially important to step back and encourage other
voices to join in. Be aware of how much time is taken up by dominant members of
the group. Provide alternative ways to contribute or participate when possible.

Be inclusive of everyone in an interaction, respecting and facilitating
people's participation whether they are:

  * Remote (on video or phone)
  * Non-native language speakers
  * Coming from a different culture
  * Using pronouns other than "he" or "she"
  * Living in a different time zone
  * Facing other challenges to participate

Think about how you might facilitate alternative ways to contribute or
participate. Make way for other voices and listen actively to them.

### Be civil and considerate

Your work will be used by other people, and you in turn will depend on the work
of others. Any decision you take will affect users and colleagues, and you
should take those consequences into account when making decisions. Remember
that we are a world-wide community. You may be communicating with someone with
a different primary language or cultural background.

Members of the community are considerate of their peers. We are thoughtful when
addressing the efforts of others, keeping in mind that often times the labor
was completed simply for the good of the community.

### Be respectful

We are respectful of others, their positions, their skills, their commitments,
and their efforts. We are respectful of the volunteer efforts that permeate the
ITK community. We are respectful of the processes set forth in the community,
and we work within them. When we disagree, we are courteous in raising our
issues.

We *must* be able to speak directly when we disagree and when we think we need
to improve. We cannot withhold hard truths. Doing so respectfully is hard,
doing so when others do not seem to be listening is harder, and hearing such
comments when one is the recipient can be even harder still. We need to be
honest and direct, as well as respectful.

Value each other's ideas, styles and viewpoints. When we disagree, try to
understand why. Being unable to understand why someone holds a viewpoint does
not mean that they are wrong. Be respectful to differing viewpoints and
experiences. Disagreements, both social and technical, happen all the time and
ITK is no exception. Try to understand where others are coming from, as seeing
a question from their viewpoint may help find a new path forward. Be open to
different possibilities and to being wrong. Be kind in all interactions and
communications, especially when debating the merits of different options. Our
goal should not be to "win" every disagreement or argument. A more productive
goal is to be open to ideas that make our own ideas better. The best solutions
to hard problems rarely come from a single angle. Strive to be an example for
inclusive thinking. "Winning" is when different perspectives make our work
richer and stronger.

Do not forget that it is human to err: blaming each other does not get us
anywhere, while we can learn from mistakes to find better solutions.

Most importantly, disagreement is no excuse for poor manners. We might all
experience some frustration now and then, but we cannot allow that frustration
to turn into a personal attack. We do not allow disagreement to persist and
fester leaving others uncertain of the agreed direction. We work together to
resolve conflict, assume good intentions and do our best to act in an empathic
fashion. We work together to resolve conflict, and assume good intentions. We
may all experience some frustration from time to time, but we do not allow
frustration to turn into a personal attack.

A community where people feel uncomfortable or threatened is not a productive
one.

### Be collaborative

What we produce is a complex whole made of many parts, it is the sum of many
efforts, long working hours, personal endeavors and sleepless nights.
Collaboration between teams that each have their own goal and vision is
essential; for the whole to be more than the sum of its parts, each part must
make an effort to understand the whole.

Our work will be used by other people, and in turn we will depend on the work
of others. When we make something for the benefit of the project, we are
willing to explain to others how it works, so that they can build on the work
to make it even better. Any decision we make will affect users and colleagues,
and we take those consequences seriously when making decisions.

Collaboration reduces redundancy and improves the quality of our work.
Internally and externally, we celebrate good collaboration. Wherever possible,
we work closely with upstream projects and others in the free software
community to coordinate our efforts. We prefer to work transparently and
involve interested parties as early as possible.

We recognize that the project works better when we trust the teams closest to a
problem to make the decision for the project. We strive to find common ground,
and failing that, the matter can be escalated to the ITK governance structure
represented by the ISC members and its designated leaders who can review the
decision, arbitrate and provide clarity and direction. Ultimately, if a
decision has been taken by the people responsible for it, and is supported by
the project governance, it will stand. None of us expects to agree with every
decision, and we value highly the willingness to stand by the project and help
it deliver even on the occasions when we ourselves may prefer a different
route.

We value discussion, data, decisiveness and consensus. We gather opinions, data
and commitments from concerned parties before taking a decision. We expect
leaders to help teams come to a decision in a reasonable time, to seek guidance
or be willing to take the decision themselves when consensus is lacking, and to
take responsibility for implementation.

The poorest decision of all is no decision: clarity of direction has value in
itself. Sometimes all the data are not available, or consensus is elusive. A
decision must still be made because it enables the project as a whole to move
forward faster and to adapt to times. There is no guarantee of a perfect
decision every time - we prefer to err, learn, and err less in future than to
postpone action indefinitely.

Resoluteness in decisions demands considerateness; take bold decisions, but do
so mindful of the challenges they present for other community members and the
use of ITK itself across different projects, and work to soften the impact of
those decisions on them. Communicating changes and their reasoning clearly and
early on is as important as the implementation of the change itself.

### Be careful in the words that we choose

We are careful and respectful in our communication and we take responsibility
for our own speech. Be kind to others. Do not insult or put down other
participants. We will not accept harassment or other exclusionary behavior.

### Take responsibility for our words and our actions

Be aware of your impact and how intense interactions may be affecting people.
Be direct, constructive and positive. We can all make mistakes; when we do, we
take responsibility for your impact and your mistakes – if someone says they
have been harmed through your words or actions, listen carefully, apologize
sincerely, and correct the behavior going forward. If someone has been harmed
or offended, we listen carefully and respectfully, and work to right the wrong.

A simple apology can go a long way. It can often de-escalate a situation, and
telling someone that you are sorry is an act of empathy that does not
automatically imply an admission of guilt.

### Be concise

Value the each other's time. Keep in mind that what you write once will be read
by hundreds of persons. Writing a short message means people can understand the
conversation as efficiently as possible. Messages that are brief and to the
point take more time to write, but are repaid many times over when other
members of the list make the same effort. Short messages should always strive
to be empathetic, welcoming, friendly and patient. When a long explanation is
necessary, consider adding a summary.

Try to bring new ideas to a conversation so that each message adds something
unique to the thread, keeping in mind that the rest of the thread still
contains the other messages with arguments that have already been made.

Try to stay on topic, especially in discussions that are already fairly large.
If you must change the topic, start a new thread. Also, avoid flooding the list
with long threads by reading the entire thread first, instead of responding
quickly to many emails in a short period of time.

### Be inquisitive

Nobody knows everything! We will try hard to be responsive and helpful.

### Moderate your expectations

Please respect that community members choose how they spend their time in the
project. A thoughtful question about your expectations is preferable to demands
for another person's time. Respect the time and energy of long-time community
members.

### Ask for help when unsure

Nobody is expected to be perfect in the ITK community. Asking questions early,
and bringing discussions to the table through the appropriate channels, avoids
many problems (whether they are technical, such as design flaws, technical
debt, etc., or intellectual, etc.) later, so questions are encouraged, though
they may be directed to the appropriate forum. Those who are asked should be
responsive and helpful.

We do our best to answer to all questions and concerns in a timely manner. But
we may fail to do so sometimes. Please, assume good faith and do not feel
discouraged. It may be a matter of asking incomplete, poorly formatted or too
broad or generic questions; some other times, the questions may have been
answered previously. Please take some time by doing research in FAQs,
documentation and other ITK resources, as well as with search engines before
asking questions.

We welcome new members, and love to see them becoming important people in our
community.

### Step down considerately

When somebody leaves or disengages from the ITK project, we ask that they do so
in a way that minimizes disruption to the Project. They should tell people they
are leaving and take the proper steps to ensure that others can pick up where
they left off.

Lead By Example
---------------

We all lead by example, in debate and in action. We encourage new participants
to feel empowered to lead, to take action, and to experiment when they feel
innovation could improve the project. Leadership can be exercised by anyone
simply by taking action, there is no need to wait for recognition when the
opportunity to lead presents itself.

To err is human; whenever we make a mistake, we take responsibility for it, and
we work to right the wrong.

We encourage everyone to participate and are committed to building a community
for all. Although we may not be able to satisfy everyone, we all agree that
everyone is equal. Whenever a participant has made a mistake, we expect them to
take responsibility for it.

Unacceptable Behavior
---------------------

Code of Conduct violations reduce the value of the community for everyone and
we take them seriously.

The following behaviors are considered to be unacceptable under these
guidelines:

  * Personal attacks and violent threats or language directed against another
  person, including but not limited to offensive comments related to gender,
  gender identity and expression, gender identity, sexual orientation, ability,
  physical appearance, body, age, race, ethnicity, nationality, language,
  religion or otherwise dimension of diversity.
  * Sexist, racist, or otherwise discriminatory jokes and insults.
  * Deliberate misgendering or use of "dead" or rejected names.
  * Unwelcome comments regarding a person's lifestyle choices and practices,
  including those related to food, health, parenting, drugs, and employment.
  * Derogatory language.
  * Sustained disruption of discussion.
  * Excessive profanity. Avoid swearwords; people differ greatly in their
  sensitivity to swearing.
  * Publishing (or threatening to publish) other people's personally
  identifying information and/or material ("doxing").
  * Deliberate "outing" of any aspect of a person's identity without their
  consent except as necessary to protect other community members or other
  vulnerable people from intentional abuse.
  * Sharing of non-harassing private communication, such as emails sent
  privately or non-publicly, or unlogged forums such as IRC channel history,
  without the sender's consent.

Harassment will not be tolerated in any of its forms either. Specifically:

  * Unwelcome sexual attention or physical contact, including simulated
  contact (e.g., textual descriptions like "hug" or "backrub"), or otherwise
  creating sexualized environment.
  * Posting gratuitous or off-topic sexually explicit or violent material.
  * Incitement of violence towards any individual, including encouraging a
  person to commit suicide or to engage in self-harm.
  * Deliberate intimidation.
  * Stalking or following.
  * Harassing photography or recording, including logging online activity for
  harassment purposes
  * Pattern of inappropriate social contact, such as requesting/assuming
  inappropriate levels of intimacy with others.
  * Continued one-on-one communication after requests to cease.

Although the above list cannot be exhaustive, we will not tolerate
discrimination based on any of the protected characteristics in our
[Diversity Statement](Motivation.md#diversity-statement).

The relative anonymity (if any) in the discussion forums is no shelter for
unacceptable behavior.

Influencing Unacceptable Behavior
---------------------------------

We will treat advocating for, influencing or encouraging other members to cause
hostility, or leading to any of the above behavior or activities the same way
we treat the activities themselves, and thus the same consequences apply.

Sharing Data
------------

When sharing your testing data, either as an input to an ITK contribution or as
part of a discussion topic or help request, please bear in mind that you must
remove any Personal Identifiable Information (PII) from your images prior to
making them available. Please bear in mind that besides cleaning pixel data,
other meta-data (such as individual attributes when dealing with DICOM files)
may require additional de-identification processes.

For dealing with DICOM files/medical images, please read the related
documentation (namely, the
[DICOM Supplement 55](ftp://medical.nema.org/medical/dicom/final/sup55_ft.pdf)
and
[DICOM Supplement 142](ftp://medical.nema.org/medical/dicom/final/sup142_ft.pdf)).
If you still need help for de-identifying your images, please ask on the
[ITK discussion](https://discourse.itk.org/).

Please, simply avoid using images that, despite having been used in image
analysis and related areas historically (e.g. "Lena"), may be interpreted as
being degrading to part of our community, or reinforcing stereotypes.

Community members shall not attempt to identify de-identified images.

Feedback
--------

Everyone is encouraged to ask questions about these guidelines. We would be
happy to hear suggestions to improve any aspect of this Code of Conduct.

If you are organizing an event or activity where ITK is a building block,
please reach us for including a policies concerning aspects of ITK.

Modifications to these Guidelines
---------------------------------

The ISC may amend these guidelines in order to adapt to, and may also vary the
associated procedures where appropriate in a particular case. Community
members' agreement to comply with these guidelines will be deemed agreement to
any changes to it. In case ISC amends the guidelines, the new guidelines will
be reachable as a new version of this document. You can sign up for updates by
subscribing to this repository's notifications in your settings.

License and Attribution
-----------------------

This document and all associated processes are only possible with the hard work
of many, many ITK community members, and other open-source initiative members.
These guidelines have sought inspiration and have drawn content with
modification from

  * [The Open Source Initiative](https://opensource.org/codeofconduct)
  * [GitLab](https://about.gitlab.com/handbook/support/policies/#code-of-conduct)
  * [Python](https://www.python.org/psf/codeofconduct/)
  * [Django](https://www.djangoproject.com/conduct/reporting/)
  * [Scipy](https://docs.scipy.org/doc/scipy//reference/dev/conduct/code_of_conduct.html)
  * [Nipype](https://github.com/nipy/nipype/blob/master/CODE_OF_CONDUCT.md)
  * [Jupyter](https://github.com/jupyter/governance/blob/master/conduct/code_of_conduct.md)
  * [The Linux Foundation](https://www.linuxfoundation.org/events/code-of-conduct/)
  * [Ubuntu](https://www.ubuntu.com/about/about-ubuntu/conduct)
  * [Brainhack](http://www.brainhack.org/code-of-conduct.html)
  * [Mozilla](https://www.mozilla.org/en-US/about/governance/policies/participation/)
  * [Contributor Covenant](https://www.contributor-covenant.org/)

Additional text from the
[Citizen Code of Conduct](http://citizencodeofconduct.org), the
[Geek Feminism Wiki Harassment Policy contents](http://geekfeminism.wikia.com/wiki/Category:Harassment_policy),
and the
[TODO Group Open Code of Conduct](http://todogroup.org/opencodeofconduct/)
have also been adapted to build this Code of Conduct.

We are grateful to those projects for contributing these materials under open
licensing terms for us to easily reuse.

All content on this page is licensed under a Creative Commons Attribution
license.
