ITK Code of Conduct Enforcement Guidelines
==========================================

Enforcing the Code of Conduct impacts our community today and for the future.

As a member of the ITK community, you are also a steward of the values
described in this Code of Conduct. Not all problems need to be resolved via
formal processes, and often a quick, friendly but clear word on an online forum
or in person can help resolve a misunderstanding and de-escalate things.

However, sometimes these informal processes may be inadequate: they fail to
work, there is urgency or risk to someone, nobody is intervening publicly and
you do not feel comfortable speaking in public, etc. For these or other
reasons, structured guidelines and follow-up may be necessary and here we
provide the means for that.

Failure to observe this Code may be grounds for reprimand, probation, or
temporary or permanent ban from the ITK spaces.

In order to make sure that the response to any incident, issue, violation or
breach of this Code of Conduct issue is consistent and fair, all responses to
reports of conduct violations will be managed by the [ISC Code of Conduct
Committee](http://www.insightsoftwareconsortium.org/) ("the Committee"
hereafter) [note: still working the process; this will be filled in as they
become available and prior to final upload into the rendered site].

The ISC Officers will approve the members of this three person committee. The
members will be drawn from our entire community, and we intend that it not be
only ISC members: anyone who is actively engaged with ITK can propose to join
this committee (we will explicitly solicit volunteers when short of three
members). One member will be designated chair of the group by the ISC Officers
and will be responsible for all reports back to the ISC Officers.

When reviewing enforcement measures, the Code of Conduct Committee will keep
the following values and guidelines in mind:

  * **Act in a personal manner rather than impersonal**. The Committee can
  engage the parties to understand the situation, while respecting the privacy
  and any necessary confidentiality of reporters. However, sometimes it is
  necessary to communicate with one or more individuals directly: the
  Committee's goal is to improve the health of our community rather than only
  produce a formal decision.
  * **Emphasize empathy for individuals rather than judging behavior, avoiding
  binary labels of "good" and "bad/evil"**. Overt, clear-cut aggression and
  harassment exists and will be addressed unambiguously. But many scenarios
  that can prove challenging to resolve are those where normal disagreements
  devolve into inappropriate behavior from multiple parties. Understanding the
  full context and finding a path that re-engages all is hard, but ultimately
  the most productive for our community.
  * **Help increase engagement in good discussion practice**: try to identify
  where discussion may have broken down and provide actionable information,
  pointers and resources that can help enact positive change on these points.
  * **Be mindful of the needs of new members**: provide them with explicit
  support and consideration, with the aim of increasing participation from
  underrepresented groups in particular.
  * **Individuals come from different cultural backgrounds and native
  languages**. While lack of intent to harm is not an excuse, try to identify
  any honest misunderstandings caused by a non-native speaker and help them
  understand the issue and how to change. Complex discussion in a foreign
  language can be very intimidating, and we want to grow our diversity also
  across nationalities and cultures.
  * **Our actions will reflect compassion for all individuals**. We will seek
  to understand, to educate, and, as necessary, take action.

The Committee must agree on a resolution by consensus. If the group cannot
reach consensus and deadlocks for over a week, the group will turn the matter
over to the ISC Officers for resolution.

In this document, the term "the originator" refers to the person(s) that have
violated this Code of Conduct and originated an incident; the term "the
affected party(ies)" refers to the person(s) that have suffered the attack of "the
originator" under the forms described in the
[Unacceptable Behavior](CODE_OF_CONDUCT.md#unacceptable-behavior) section.

Responsibilities
----------------

The ISC Code of Conduct Committee is responsible for clarifying the standards
of acceptable behavior and they are expected to take appropriate and fair
corrective action in response to any circumstances of unacceptable behavior.

For onsite or offsite ITK events (e.g. trainings, hackathons) where no
Committee members may be present, an event organizer will act as their
delegate. They will forward any reports to the Committee, as well as a summary
of any action they may have taken during the event (see
[Event Incident Report](Reporting.md#event-incident-report)).

The ISC Code of Conduct Committee has the right and responsibility to remove,
edit, or reject project comments, commits, code, wiki edits, issues, and other
contributions that are not aligned to this Code of Conduct, or to ban
temporarily or permanently any contributor for other behaviors that they deem
inappropriate, threatening, offensive, or harmful.

ISC Code of Conduct Committee members or ITK maintainers who do not follow or
enforce the Code of Conduct in good faith may face temporary or permanent
repercussions as determined by other members of the Committee.

If any Code of Conduct violation or breach report involves any members of the
Committee, or if they feel they have a conflict of interest in handling it,
then they will recuse themselves from considering your report. Alternatively,
if for any reason you feel uncomfortable making a report to the committee, then
you can contact

  * [Matthew McCormick](mailto:matt.mccormick@kitware.com), the ISC President
  * [Nick Tustison](mailto:ntustison@virginia.edu), the ISC Secretary

Mediation
---------

Voluntary, informal mediation is a tool at our disposal. In contexts such as
when two or more parties have all escalated to the point of inappropriate
behavior, it may be useful to facilitate a mediation process. This is only an
example: the Committee can consider mediation in any case, mindful that the
process is meant to be strictly voluntary and no party can be pressured to
participate. If the Committee suggests mediation, it should:

  * Find a candidate who can serve as a mediator.
  * Obtain the agreement of the reporter(s). The reporter(s) have complete
  freedom to decline the mediation idea, or to propose an alternate mediator.
  * Obtain the agreement of the reported person(s).
  * Settle on the mediator: while parties can propose a different mediator than
  the suggested candidate, only if common agreement is reached on all terms can
  the process move forward.
  * Establish a timeline for mediation to complete, ideally within two weeks.

Report Handling
---------------

Upon reception of an incident report, the Committee (or a Committee member)
will contact the reporter personally to confirm receipt. This reply must be
sent within 24 hours, or the next business day, and the group should strive to
respond much quicker than that.

We know that it is painfully common for Internet communication to start at or
devolve into obvious and flagrant abuse. We will deal quickly with clear and
severe breaches like personal threats, violent, sexist or racist language.

When the Committee (or a Committee member) receives a report, they will first
determine whether the report is about a clear and severe breach (see
[Incident Reporting Resolution & Code of Conduct Enforcement](#incident-reporting-resolution-&-code-of-conduct-enforcement)).

The Committee will then review the incident and determine, to the best of their
ability:

  * What happened.
  * Whether the incident constitutes a Code of Conduct violation.
  * Who is/are the originator(s).
  * Who are the affected party(ies).
  * Whether this is an ongoing situation, and there is a threat to anyone's
  physical safety.
  * Required response.

This information will be collected in writing, and whenever possible the
Committee's deliberations will be recorded and retained (i.e. chat transcripts,
email discussions, recorded conference calls, summaries of voice conversations,
etc.).

If a report does not contain enough information, the Committee will try to all
relevant data before acting. The Committee is empowered to act on the ISC
Officers' behalf in contacting any individuals involved to get a more complete
account of events.

When a member of the Code of Conduct Committee becomes aware of a clear and
severe breach that requires immediate actions to be taken in addition to the
regular report handling process, they will do the following:

  * Immediately disconnect the originator from all ITK communication channels.
  * Reply to the reporter that their report has been received and that the
  originator has been disconnected.
  * In every case, the Committee should make a reasonable effort to contact the
  originator, and tell them specifically how their language or actions qualify
  as a clear and severe breach. The Committee should also say that, if the
  originator believes this is unfair or they want to be reconnected to ITK,
  they have the right to ask for a review (see
  [Addressing Grievances](#addressing-grievances).
  * The Committee will formally review and sign off on all cases where this
  mechanism has been applied to make sure it is not being used to control
  ordinary heated disagreement.

It is important to retain an archive of all activities of this Committee to
ensure consistency in behavior and provide institutional memory for the
project. To assist in this, the default channel of discussion for this
Committee will be a private mailing list including current members of the
Committee, as well as members of the ISC Office upon justified request. If the
Committee finds the need to use off-list communications (e.g. phone calls for
early/rapid response), it should in all cases summarize these back to the list
so there's a good record of the process.

The Code of Conduct Committee should aim to have a resolution agreed upon
within one week in case mediation does not become necessary. In the event that
a resolution cannot be determined in that time, the Committee will respond to
the reporter(s) with an update and projected timeline for resolution.

All reports will be kept confidential. In some cases we may determine that a
public statement will need to be made. If that's the case, the identities of
all affected parties and reporters will remain confidential unless those
individuals instruct us otherwise.

Incident Reporting Resolution & Code of Conduct Enforcement
-----------------------------------------------------------

All complaints will be reviewed and investigated and will result in a response
that is deemed necessary and appropriate to the circumstances.

In addition to conducting any investigation, they can provide a range of
resources, from a private consultation to other community resources. They will
involve other colleagues, including legal counsel, only as needed to
appropriately address each situation.

If the act is ongoing, or involves a threat to anyone's physical safety (e.g.
threats of violence), any Committee member (or the designated delegate) may
and should act immediately (before reaching consensus) to protect the safety of
those involved. This can include contacting law enforcement (or other local
personnel). This means the Committee may delay an "official" response until we
believe that the situation has ended and that everyone is physically safe.

Committee members (or designated delegates) present at these incidents must
report these incidents to the Committee for review within 24 hours (see
#[event-incident-report]).

Once the Committee has a complete account of the events in the light of the
report review, they will make a decision as to how to response. Responses may
include:

  * Taking no further action
     * if we determine no violations have occurred.
     * if the matter has been resolved publicly while the Committee was
     considering responses.
  * Coordinating voluntary mediation: if all involved parties agree, the
  Committee may facilitate a mediation process as detailed above.
  * Remind publicly, and point out that some behavior/actions/language have
  been judged inappropriate and why in the current context, or can be hurtful
  to some people, requesting the community to self-adjust.
  * A private reprimand from the Committee to the individual(s) involved. In
  this case, the Chair will deliver that reprimand to the individual(s) over
  email, cc'ing the Committee.
  * A public reprimand. In this case, the Committee Chair will deliver that
  reprimand in the same venue that the violation occurred, within the limits of
  practicality. E.g., the original ITK discussion forum for an email/posting
  violation, but for a chat room discussion where the person/context may be
  gone, they can be reached by other means. The Committee may choose to publish
  this message elsewhere for documentation purposes.
  * A request for a public or private apology, assuming the reporter agrees to
  this idea: they may at their discretion refuse further contact with the
  originator. The Chair will deliver this request. The Committee may, if it
  chooses, attach "strings" to this request: for example, the Committee may ask
  a originator to apologize in order to retain one's membership on a mailing list.
  * A "mutually agreed upon hiatus" where the Committee asks the individual to
  temporarily refrain from community participation. If the individual chooses
  not to take a temporary break voluntarily, the Committee may issue a
  "mandatory cooling off period".
  * A temporary or permanent ban from some or all ITK spaces (discussion
  forums, code repositories, etc.). The Committee will maintain records of all
  such bans so that they may be reviewed in the future or otherwise maintained.
  * Ask to leave the ITK event (if the event is ongoing, e.g. training,
  hackacthon) where the code violation has taken place with no refund (if
  applicable), depending on the circumstances.

Participants asked to stop unacceptable behavior are expected to comply
immediately. If an individual engages in unacceptable behavior, or has been
issued a warning three times, the Committee may take any action they deem
appropriate, up to and including a permanent ban from the ITK community
without warning.

The Committee reserves the right to exclude any participant found to be
enagaging in harassing behavior from participating in any future ITK events,
trainings, hackathons or other inperson activities and ancillary events and
forums.

Intentional efforts to exclude people (except as part of a consequence of the
guidelines or other official action) from ITK activities are not acceptable and
will be dealt with appropriately.

In addition, any participants who abuse the reporting process will be
considered to be in violation of these guidelines and subject to the same
consequences. False reporting, especially to retaliate or exclude, will not be
accepted or tolerated.

Once a resolution is agreed upon, but before it is enacted, the Committee (or
a member of the Committee) will contact the original reporter to let them know
what action (if any) the Committee will be taking. The Committee will take into
account feedback from the reporter on the appropriateness of our response, but
the Committee reserves the right to act on it.

Finally, the Committee will make a report on the situation to the ISC Officers
(as well as the ITK maintainers in the event of an ongoing resolution, such as
a ban), including the following information:

  * Information about the ITK communication channel or event where the Code
  incident occurred.
  * The statement of what occurred, including a publicly available record (e.g.
  audiovisual material), if any.
  * The Committee review: whether the incident event constituted a Code of
  Conduct violation, the originator, the affected party(ies), whether there
  was a threat to anyone's physical safety, and the agreed response or
  measures taken to stop the violation and repair the honor of the affected
  party(ies).

The Officers may choose to disclose a public report of the incident.

The Committee will protect the identity of the reporter, an treat the contents
of incident reports as confidential (unless the reporter agrees otherwise by
providing their personal data). The Committee will never publicly discuss the
issue; all public statements will be made by the chair of the Code of Conduct
Committee or the ISC Officers.
